
'       //////////////////////////-\\\\\\\\\\\\\\\\\\\\\\\\\\
'       /                                                   \
'       PlotFnArray10       tenochtitlanuk     August 2009  |
'       \                                                   /
'       \\\\\\\\\\\\\\\\\\\\\\\\\\_//////////////////////////

'   PURPOSE
'           Program to autoscale & draw functions of x between chosen limits.
'           Also to draw the graph of the first derivative- the 'gradient'.

'   HISTORY
'           Grew out of a demo for a JB forum question on gradients.

'   BUGS
'           Large numbers displayed wrongly on limits. ( '%' overflow signs)

'   TO-DOs.
'           Add way to change limits without changing function.
'           Add a mouse_x input that draws the tangent at that x coordinate
'           Add routine to convert save to gif/jpg & resize?
'           Add print screen
'           Add button to redraw with x and y axes visible.
'           Add ability to ask for and save new functions & limits.
'               ...(may need to change to a saved file instead of read /data. Self-modify *.bas??
'           Add vertical lines at f'( x) =0, ie 'turning points' ==f(x) maxima and minima.
'           Add option for a mouse-driven tangent on f(x) to show f'(x) (presently a menu option)
'               ...allow variable speed or to interrupt it.
'           Add a circle round origin when it is on-screen.

'           Add a third graph for definite integral between the x boundaries?

'           ? Use 'on error' to trap 'division by zero'             ???
'           ? Try to allow for results that 'go to infinity'        ???
'           ? Add an option to select degrees rather than radians   ???

'   USAGE
'           Enter your choice of function and x range lower /upper limits in the data statements.
'               BUT be careful it won't cause 'division by zero' or other errors!!
'               eg if you want y = y =x *sin( 1 /x) you must choose a range not including x =0.

'           I used y =xin^2 -5*xin +6 when testing.
'               in the range 0 <x<4, max is at x=6; has minimum at x=2.5
'               and zero crossings at x=2 and x=3
'               Its derivative will be 2x -5, is straight line from (0,-5) to (4, 3)
'   /////////////////////////////////////////////////////

nomainwin

'   NB For trig functions, we work in radians- each about 57 degrees

'   YOU can enter new functions and upper & lower x values you want, as new DATA.

'   The program calculates the max & min of the function & its gradient/ derivative
'       and plots them both, indicating the max & min on both axes.

'   It also puts the data in a text editor so you could copy /paste to a spreadsheet.

'   NB various 'pathological' functions may go to infinity or error-out with 'divide by zero'.

dim x( 800), y( 800), dy( 800), dybydx( 800)    '   arrays for the 800 data values
dim lh( 50), rh( 50), fn$( 50)                  '   arrays for up to 50 stored functions and limits lefthand & righthand

UpperLeftX   =   1
UpperLeftY   =   1
WindowWidth  =1020
WindowHeight = 740

graphicbox #m.g0,              1,   1,   1,   1
graphicbox #m.g1,            100,   0, 800, 304
graphicbox #m.g2,            100, 338, 800, 304

texteditor #m.t1,            100, 658, 800,  50

statictext #m.s1, "",         40,  10,  60,  30
statictext #m.s2, "",         40, 270,  60,  30
statictext #m.s3, "",         40, 350,  60,  30
statictext #m.s4, "",         40, 600,  60,  30
statictext #m.s5, "",         70, 305,  78,  30
statictext #m.s6, "",        850, 305,  80,  30

statictext #m.st1, "f( x)",   10, 150,  80,  60
statictext #m.st2, "f'( x)",  10, 450,  80,  60
statictext #m.st3, "",       910, 200, 100,  80
statictext #m.st4, "",       910, 500, 100,  80
statictext #m.st5, "",       200, 307, 610,  30

dim fn$( 100)

i  =1

d$ =""

global dx

while d$ <>"end"                    '   Fill array for the listbox selector.
    read d$: fn$( i) =d$
    read d:  lh(  i) =d
    read d:  rh(  i) =d
    i       =i +1
wend

i =5                                '   Select as default the fifth graph.

menu #m, "&Function",_
        "&Select fn from list", [SelFn],_
        "&Define a new fn",     [DefineFn],_
        |, "D&raw Tangents",    [DrawTangents],_
        |, "&Screensave",       [screensave],_
        "&Datasave",            [datasave],_
        |, "Help",              [help],_
        |, "&Quit",             [quit]

open "Plotting a function & its first derivative" for window_nf as #m

#m "trapclose [quit]"

#m.g1, "down ; color darkblue ; size 1"
#m.g2, "down ; color red ;      size 1"

#m.s5,  "!font arial   16 bold"
#m.s6,  "!font arial   16 bold"

#m.st1, "!font courier 24 bold"
#m.st2, "!font courier 24 bold"
#m.st3, "!font courier 24 bold"
#m.st4, "!font courier 24 bold"
#m.st5, "!font courier 18 bold"

[main]

function$ =fn$( i)
                                                             '  Print headings for data table.
#m.t1, "!cls"
#m.t1,  "x"; ","; "dx"; ","; "y( p)"; ","; "ymax"; ","; "ymin"; ",";  "dy( p)"; ","; "dybydx( p)"; ","; "dybydxmin"; ","; "dybydxmax"

#m.st5, "Fn_#"; i; "( x) ="; left$( function$ +space$( 40), 28); "..."

#m.g1, "cls"
#m.g2, "cls"

xmin      =lh( i)                                            '   Set the x axis lower and upper limits
xmax      =rh( i)

if ( xmin <0) and ( xmax >0) then                            '   ie range includes x =0, so draw y axis vertically thro' it.
    x0 =int( 800 *abs( xmin) /( xmax -xmin))
    #m.g1, "down ; size 2 ; line "; x0; " 0 "; x0; " 304 ; up ; size 1"
    #m.g2, "down ; size 2 ; line "; x0; " 0 "; x0; " 304 ; up ; size 1"
end if

ymax      =-1E9                                             '   In RB don't have the max() & min() functions....
ymin      = 1E9                                             '       where this was originally started.

dymax     =-1E9
dymin     = 1E9

dybydxmax =-1E9
dybydxmin = 1E9

eps       = 1E-12                                           '   for 'equality' tests

dx =( xmax -xmin) /800                                      '   so getting 800 positions to match the graphicbox
                                                            '          & needed to calculate dy by dx.

for p =0 to 800                                             '   For 800 data points between given min x and max x.
    x =xmin +p *dx                                          '   Calculate x values
    x( p) =x                                                '       & store in array x()
                                                            '   Find corresponding y values and their max & min. Store in array y().
    y( p) =eval( function$)                                 '   Calculate the function at this x value.

    if y( p) >ymax then ymax =y( p)
    if y( p) <ymin then ymin =y( p)                         '   We now know range of values of the function- needed to scale the plot 1.

    if p >0 then
        dy( p) = ( y( p) -y( p-1))                          '   treat first value differently since previous f(x) not available
    else
        x =x -dx
        dy( p) =y( p) -eval( function$)                     '   have found how much y increased by, ie dy
    end if

    dybydx( p) =dy( p) /dx                                  '   calculate the dy/dx at this ordinate. dx is fixed at x_range/800...

    if (dybydx( p) <dybydxmin) then dybydxmin =dybydx( p)
    if (dybydx( p) >dybydxmax) then dybydxmax =dybydx( p)   '   We now know range of values of dy/dx- needed to scale the plot 2.

                                                            '   line for potential export
    #m.t1,  x( p); ","; dx; ","; y( p); ","; ymax; ","; ymin; ",";  dy( p); ","; dybydx( p); ","; dybydxmin; ","; dybydxmax
next p

                                                                        '   Go to a suitable start location. Announce if 'equal'
if abs( ymax -ymin) >eps then                                           '   NB with rounding errors may not detect equality!!!
    #m.g1, "up ; goto 1 "; 300 - ( y( 1) -ymin) / ( ymax -ymin) *300
    #m.st3, ""
else
    #m.st3, "Constant"
end if

if ( ymin <0) and ( ymax >0) then
    y0 =int( 300  -( 300 *abs( ymin) /( ymax -ymin)))
    #m.g1, "down ; size 2 ; line 0 "; y0; " 800 "; y0; " up ; size 1"
end if

if ( dybydxmin <0) and ( dybydxmax >0) then
    y0 =int( 300  -( 300 *abs( dybydxmin) /( dybydxmax -dybydxmin)))
    #m.g2, "down ; size 2 ; line 0 "; y0; " 800 "; y0; " up ; size 1"
end if

if abs( dybydxmax -dybydxmin) >eps then                                   '     NB with rounding errors may not detect equality!!!
    #m.g2, "up ; goto 1 "; 300 - ( dybydx( 1) -dybydxmin) /( dybydxmax -dybydxmin) *300; " ; down"
    #m.st4, ""
else
    #m.st4, "Constant"
end if

#m.g1, "up"                                                               '     so can put pen down to draw once data valid
#m.g2, "up"

for p =1 to 800                                                           '     Now plot the 799 points rep'g function & first derivative
    if p >=0 then #m.g1, "down"
    if p >=1 then #m.g2, "down"
    if abs( ymax -ymin) >eps then
        yy1 =300 - ( y( p-1) -ymin) /( ymax -ymin +eps) *300
        yy2 =300 - ( y( p)   -ymin) /( ymax -ymin +eps) *300
        #m.g1, "line "; p-1; " "; yy1; " "; p; " "; yy2
    else
        #m.g1, "set "; p; " 150"
    end if

    if p >2 then #m.g2, "down"

    if abs( dybydxmax -dybydxmin) >eps then
        yy1 =300 - ( dybydx( p-1) -dybydxmin) /( dybydxmax -dybydxmin) *300
        yy2 =300 - ( dybydx( p)   -dybydxmin) /( dybydxmax -dybydxmin) *300
        #m.g2, "line "; p-1; " "; yy1; " "; p; " "; yy2
    else
        #m.g2, "set "; p; " 150"
    end if
next p

#m.s1, using( "###.###", ymax)
#m.s2, using( "###.###", ymin)
#m.s3, using( "###.###", dybydxmax)
#m.s4, using( "###.###", dybydxmin)
#m.s5, using( "###.###", xmin)
#m.s6, using( "###.###", xmax)

#m.g1, "flush"
#m.g2, "flush"

wait

[DrawTangents]
WindowWidth =300
WindowHeight =250

texteditor #I.t, 10, 10, 260 , 200

open "Info" for dialog_modal as #I
    #I.t, " Tangents show the gradient of f(x) ie f'(x)."
    #I.t, " As the dot on the lower graph progresses, you"
    #I.t, " should see its amplitude is a measure of the "
    #I.t, " gradient of the upper f(x) curve."
    #I.t, ""
    #I.t, " This message disappears in ten seconds."
    timer 10000, [OnT]
    wait
    [OnT]
    timer 0
close #I

#m.g1, "color green ; size 4"
#m.g1, "rule "; _R2_NOTXORPEN
#m.g2, "color green ; size 10"
#m.g2, "rule "; _R2_NOTXORPEN

for p =0 to 800 step 1
    dy =dx *dybydx( p)
    yyplus  =300 - ( y( p)   -ymin +50 *dy) /( ymax -ymin +eps) *300
    yyminus =300 - ( y( p)   -ymin -50 *dy) /( ymax -ymin +eps) *300
    #m.g1, "line "; p -50; " "; yyminus; " ";                                                      p +50; " "; yyplus
    #m.g2, "set ";  p; " ";     300 - ( dybydx( p)   -dybydxmin) /( dybydxmax -dybydxmin) *300
    timer 100, [On]
    wait
    [On] timer 0
    #m.g1, "line "; p -50; " "; yyminus; " "; p +50; " "; yyplus
    #m.g2, "set "; p; " "; 300 - ( dybydx( p)   -dybydxmin) /( dybydxmax -dybydxmin) *300
next p

#m.g1, "rule ";_R2_COPYPEN
#m.g2, "rule ";_R2_COPYPEN
#m.g1, "flush"
#m.g2, "flush"
wait

[screensave]
#m.g0, "getbmp drawing 1 1 1020 700"       '   Offer to save graphics.
filedialog "Save Graphics as...", "*.bmp", fileName$
if fileName$ <>"" then
    bmpsave   "drawing", fileName$
    unloadbmp "drawing"
end if
wait

[datasave]
#m.t1, "!contents? g$";                 '   We'll also offer to save a csv datafile.
filedialog "Save data as...", "*.csv", fileName$
if fileName$ <>"" then
    open fileName$ for binary as #csv
    #csv, g$
    close #csv
end if
wait

[SelFn]
listbox #n.lb1, fn$(),     [selectionMade],          10,  10, 640, 400

button  #n.b1, "Continue", [selectionMade],           LL,   85,  30
button  #n.b1, " Cancel ", [cancelStatusSelection],   LL,  525,  30

WindowWidth  =680
WindowHeight =520

open "Function selector- close once selected." for graphics as #n
#n.lb1, "font courier 12 bold"
wait

[selectionMade]
#n.lb1, "selection? function$"
#n.lb1, "selectionindex? i"
close #n
if function$ ="end" then [quit]
goto [main]

[cancelStatusSelection]
notice "Status selection cancelled"
close #n

[DefineFn]
notice "Sorry, Not yet implemented"
wait

[help]
WindowWidth  =600
WindowHeight =600

texteditor #h.te, 10,  10, 570, 550

open "Help for function plotter" for window as #h

#h, "trapclose [closeh]"

#h.te, "!font arial 12"
#h.te, "This program plots a function and its gradient, between preset min & max."
#h.te, "Use the menu to select a function, and to save the graph or data file"
#h.te, "At present you have to edit in new functions and limits as data."
#h.te, "So choose min and max x with care, as well as the function syntax!"
#h.te, "This should soon be changed...."
#h.te, "The upper and lower f(x) and f'(x) values are approximate."
#h.te, "The x and y axes are plotted if they are in-range."
#h.te, "If a function or its gradient are constant, it says so and max & min are equal."
#h.te, "Horizontal places on f(x) should match f'(x) zero-crossings"
#h.te, "There is a menu option to show the tangents to help visualize this."
#h.te, "Large uphill   gradient of f(x) == large +ve value of f'(x)"
#h.te, "Large downhill gradient of f(x) == large -ve value of f'(x)"
#h.te, ""
#h.te, "NB in your own functions, watch for divide-by-zero' or infinity errors!!"
#h.te, "NNB this is a work-in-progress. See comment lines!"
#h.te, "There are known bugs and things to implement"

wait

[closeh]
close #I
close #h
wait


    '   Function of x                                                         x_min   x_max
                      '       Linear functions
data "3"              ,                                                         0,     10   '   horizontal line, zero gradient
data "x"              ,                                                        -1,     10
data "-1 *x"          ,                                                        -1,     10
data "3 *x"           ,                                                        -1,     10   '   rising straight line gradient =3

                      '       Quadratic and other powers
data "x^2 +1 *x -6"   ,                                                        -4,      4   '   quadratic, roots -1 and 2
data "x^2 -5 *x +6"   ,                                                         1,      4
data "x^2 +2 *x +4"   ,                                                        -4,      6
data "x^2 -3 *x +1"   ,                                                        -4,      4
data "x^3 +x^2 -4 *x -4",                                                      -3,      3   '   cubic- two inflections
data "1/ x"           ,                                                         0.01,   1   '   hyperbola

                      '        Trig. ( x in radians..)
data "sin( x)"        ,                                                        -2,      6   '   classic sin wave
data "cos( x)"        ,                                                        -2,      6
data "sin( 2 *x)"     ,                                                        -2,      6
data "sin( x) +0.1 *sin( 10 *x)",                                              -2,      6   '   note how the high freq'y is emphasised in f'( x)
data "sin( x) +0.01*rnd(1)",                                                   -2,      6   '   note how the high-freq'y noise dominates f'( x)
data "tan( x)"        ,                                                         0,     20   '   note the near-infinity problems..)"
data "acs( x)"        ,                                                         0,      1   '   inverse cos
data "asn( x)"        ,                                                         0,      1   '   inverse sin
data "atn( x)"        ,                                                        -1,      1
data "sin( 1 /x)"     ,                                                         0.01,   1
data "x *sin( 1/x)"   ,                                                         0.03,   1
data "sin( x)^2 +cos( x)^2",                                                   -2,      6   '   hope you predicted what this gives!
data "sin( x)^2/x^2",                                                           0.001, 16
                      '        Oddities
data "rnd( 1)"        ,                                                         0,     10
data "50 +10 *rnd( 1)",                                                         0,    100

data "int( x)"        ,                                                         0,     10   '   staircase
data "x -int( x)",                                                              0,     10
data "x mod 10)"      ,                                                         0,    100   '   deltas
data "((( x mod 3) -1) >1) -0.2" ,                                              0,     10

                      '        Decay & growth
data "exp(  1 *x)"    ,                                                         0.01,   3   '   classic exponenential growth...
data "exp(  2 *x)"    ,                                                         0.01,   3   '       ... and decay.
data "exp( -1 *x)"    ,                                                         0.01,   3
data "exp( -0.1 *x) *sin( 5 *x)",                                               0.01,  50
data "exp(  0.1 *x) *sin( x)",                                                  0.01,  50

                      '        Fourier synthesis
data "sin( x) +1/3 *sin( 3*x) +1/5 *sin( 5*x) +1/7 *sin( 7*x) +1/9 *sin( 9*x)", 0,     40   '   approximating a square wave
data "cos( x) +1/3 *cos( 3*x) +1/5 *cos( 5*x) +1/7 *cos( 7*x) +1/9 *cos( 9*x)", 0,     40

                      '        Beats
data "1 *sin( 1.0  *x) +1 *sin( 1.2 *x)",                                       0,     80   '   adding sin waves to get 'beats'
data "2 *sin( 1.05 *x) *cos( 0.1 *x)",                                          0,     80   '   transformation of the above..

                       ' Tchebychev polynomials                                                                   -1,      1
data "128 *x^8 -256 *x^6 +160 *x^4  -32 *x^2   +1",                            -1,      1
data "256 *x^9 -576 *x^7 +432 *x^5 -120 *x^3   +9",                            -1,      1

'   Add your own functions and limits here... ###########################################

data "end",                                                                     0,      0   '   Sentinel for end-of-data

[quit]
close #m
end


