

    '   **********      MaTricks19     tenochtitlanuk      June 2011    **************

    '   Intended as a library of functions that operate on a matrix of any dimensions
    '       This means you don't have to previously dim() an array of big enough size..

    '   Matrix format is a string holding Width, Height, .... w*h terms... comma separated
    '       This means you can load, save, print a single entity- since we can't store or work
    '           on a matrix except as a collection or array terms.

    '   Would normally be used with a GUI front-end, so display is a bit crude in 'main' window.

    '   Implemented so far:-
    '       Display in matrix form
    '       Scale a matrix by multiplying all terms by a number ( scalar multipl)
    '       Get value of an element addressed by its row and column.
    '       Matrix load, save, transpose
    '       State matrix properties- row/column vector; square; ( diagonal; identity; null)
    '       Matrix multiply and exponentiation
    '       Determinant

    '   To-dos:-
    '       CHECK more test cases
    '       CHECK references to width/height/row/column are consistent!!
    '       CHECK what happens if wrong # of terms entered- & see below..
    '       Possibly implement better error-checking, esp'y the input of a new matrix
    '           for number of terms actually supplied...
    '       Matrix invert
    '       Diagonal sum- 'trace'.

    '   Possibly:-
    '       Add GUI front end
    '       Use to 'solve' equations.


    mainwin 90 60

    dim GlobalArray( 100, 100)  '   Accessible from anywhere, ie global..
                                '   Used to interchange my Matrix format and an array format
                                '   NB I at least am unlikely to need bigger array

    Mat1$ ="1,1,    1"
    Mat2$ ="2,2,    3,2,  2,1"
    Mat3$ ="3,3,    1,1,1,  1,2,4,   8,16,3"
    Mat4$ ="4,4,    2,1,4,2,   0,2,1,2,   0,2,1,1,   2,0,1,0"
    Mat5$ ="5,5,   5,9,7,8,6,   4,6,6,5,4,   3,6,8,3,3,   2,5,4,5,3,   1,1,1,1,1"
    Mat6$ ="6,6,   1,2,3,4,5,6,   6,5,4,3,2,1,   1,2,1,2,1,2,   9,2,3,6,5,4,   6,5,4,1,2,3,   1,7,4,2,3,1"
    Mat7$ ="7,7,   7,8,5,3,2,1,3,    5,6,5,6,6,5,4,   8,3,2,3,5,8,9,   9,6,3,2,1,4,7,   7,5,3,6,9,8,4,   2,1,2,2,1,3,1,   2,3,6,5,4,2,1"

    MatA$ ="4,4,   1,1,1,1,   2,4,8,16,   3,9,27,81,   4,16,64,256"
    MatB$ ="4,4,   4,-3,4/3,-1/4,-4.3333,    4.75,-2.333,11/24,1.5,   -2,1.1666,-0.25,-0.1666,0.25,-0.166,0.04166"
    MatC$ ="1,4,   1,2,3,4"
    MatD$ ="4,1,   6,  5,  4,  3"
    MatP$ ="4,3,   1,2,3,4,   5,6,7,8,    9,10,11,12"
    MatQ$ ="3,4,   9,2,-5,   8,3,-2,   7,4,1,   6,5,4"
    MatR$ ="2,2,   3,2,  2,1"

    Scalar =3

    print "Matrix A"
    call DisplayMatrix MatA$
    print MatrixProperties$( MatA$)

    print
    print "Matrix B"
    call DisplayMatrix MatB$
    print MatrixProperties$( MatB$)

    print
    print "Matrix C"
    call DisplayMatrix MatC$
    print MatrixProperties$( MatC$)

    print
    print "Matrix D"
    call DisplayMatrix MatD$
    print MatrixProperties$( MatD$)

    print
    print "Matrix P"
    call DisplayMatrix MatP$
    print MatrixProperties$( MatP$)

    print
    print "Matrix Q"
    call DisplayMatrix MatQ$
    print MatrixProperties$( MatQ$)

    print
    print "Matrix R"
    call DisplayMatrix MatR$
    print MatrixProperties$( MatR$)

    print
    print "Element in column 3 and row 2 of MatA$ ="; GetTerm( MatA$, 3, 2)
    print "Element in column 2 and row 4 of MatB$ ="; GetTerm( MatB$, 2, 4)

    print
    print "Scalar product- 3 *Matrix A"
    MatE$ =ScaleMatrix$( Scalar, MatA$)
    call DisplayMatrix MatE$

    print
    print "Transpose of Matrix A"
    MatF$ =MatrixTranspose$( MatA$)
    print MatF$
    call DisplayMatrix MatF$
    print

    print "Product of MatP and MatQ"
    MatG$ =MatrixMultiply$( MatP$, MatQ$)
    call DisplayMatrix MatG$
    print MatrixProperties$( MatG$)
    print

    print "MatR raised to pos. integer power"
    for n =0 to 5
        print "  MatR$ ^"; n
        MatG$ =MatrixToPower$( MatR$, n)
        call DisplayMatrix MatG$
        print
    next n
    print

    print
    print "Product of A times Transpose of A"
    MatG$ =MatrixMultiply$( MatrixTranspose$( MatA$), MatA$)
    call DisplayMatrix MatG$
    print MatrixProperties$( MatG$)
    print

    input "Enter new Matrix- in stored form 'w,h,d1,d2,.....'  ( Nul to skip)"; NewM$
    if NewM$ <>"" then
        call DisplayMatrix NewM$
        filedialog "Save under what name ( blank if you don't want to save)", "mat*.jhf", fn$
        if fn$ <>"" then
            open fn$ for output as #o
                #o NewM$;
            close #o
            print "Saved as "; fn$; " as '"; NewM$; "'"
        else
            print "Not saved"
        end if
    end if
    print

    print "Saved matrices are available for reload."
    filedialog "Load stored matrix", "mat*.jhf", fn$
    if fn$ <>"" then
        open fn$ for input as #o
            nm$ =input$( #o, lof( #o))
            print "Retrieved "; fn$; " in internal matrix form as '"; nm$; "'"
        close #o
    end if
    print "Which looks like"
    call DisplayMatrix nm$
    print

    Print "Unity matrix- square 5 by 5"
    Unity$ =UnityMatrix$( 5)
    call DisplayMatrix Unity$
    print

    print "Unpacking my string format into conventional array"
    call MatrixToArrayForm MatA$
                        '   Unpacks my matrix string into a global 2D array
    for i =1 to 10      '   NB I only show first ten entries in rows and columns
        for j =1 to 10  '   If array is smaller, there'll be nuls.
                        '   If larger, not all data is displayed
                        '   If >100, errors....
            print GlobalArray( i, j),
        next j
        print
    next i



'   Determinants are 1, -1, -29, -10, -5, 0, -4608 according to Excel

    print "Matrix 1 by 1"
    call DisplayMatrix Mat1$
    print "    Determinant ="; determinant( Mat1$)

    print
    print "Matrix 2 by 2"
    call DisplayMatrix Mat2$
    print "    Determinant ="; determinant( Mat2$)

    print
    print "Matrix 3 by 3"
    print Mat3$
    call DisplayMatrix Mat3$
    print "    Determinant of Matrix 3 = "; determinant( Mat3$)

    print
    print "Matrix 4 by 4"
    call DisplayMatrix Mat4$
    print "    Determinant of Matrix 4 = "; determinant( Mat4$)

    print
    print "Matrix 5 by 5"
    call DisplayMatrix Mat5$
    print "    Determinant of Matrix 5 = "; determinant( Mat5$)

    print
    print "Matrix 6 by 6"
    call DisplayMatrix Mat6$
    print "    Determinant of Matrix 6 = "; determinant( Mat6$)

    print
    print "Matrix 7 by 7"
    call DisplayMatrix Mat7$
    print "    Determinant of Matrix 7 = "; determinant( Mat7$)

wait
    '   ______________________________________________________________________

    function determinant( in$)
        determinant =determinant2( in$)
        if instr( "3579", word$( in$, 1, ",")) then determinant =0 -determinant
    end function

    function determinant2( Mat$)
        if not( instr( MatrixProperties$( Mat$), "Square")) then notice "Has to be square.":           end
        dims =val( word$( Mat$, 1, ","))
        determinant2 =0
        select case dims
            case 1
                determinant2 =val( word$( Mat$, 3, ","))
            case 2
                determinant2 =GetTerm( Mat$, 1, 1) *GetTerm( Mat$, 2, 2) -GetTerm( Mat$, 1, 2) *GetTerm( Mat$, 2, 1)
            case else
                for i =1 to dims
                    determinant2 =determinant2 +GetTerm( Mat$, i, 1) *determinant2( ReducedMatrix$( Mat$, i)) *( 0 -1)^i
                next i
        end select


    end function

    function ReducedMatrix$( Mat$, i)
        dims =val( word$( Mat$, 1, ","))
        ReducedMatrix$ =str$( dims -1); ","; str$( dims -1); ","
        for col =2 to dims
            for row =1 to dims
                if not( ( row =i)) then ReducedMatrix$ =ReducedMatrix$ +str$( GetTerm( Mat$, row, col)) +","
            next row
        next col
    end function

    function GetTerm( in$, i, j)    '   Return element( i along row, j down column)
        w =val( word$( in$, 1, ","))
        h =val( word$( in$, 2, ","))
        if (w <i) or ( h <j) then notice "Oooopppss!!! Index lies outside matrix limits.": end
        GetTerm =eval( word$( in$, 2 +i +( j -1) *w, ","))
    end function


    sub MatrixToArrayForm in$   '   Unpacking my string format into conventional array
        w =val( word$( in$, 1, ","))
        h =val( word$( in$, 2, ","))
        for i =1 to h
            for j =1 to w
                GlobalArray( i, j) =GetTerm( in$, i, j)
            next j
        next i
    end sub

    function UnityMatrix$( n)   '   Create square unity matrix of desired size.
        if ( n <0) or ( n <>int( n)) then notice "Not a square matrix.": end
        o$ =str$( n); ","; str$( n); ","
        for i =1 to n
            for j =1 to n
                if i =j then o$ =o$ +str$( 1) +"," else o$ =o$ +str$( 0) +","
            next j
        next i
        UnityMatrix$ =o$
    end function

    function MatrixProperties$( in$)    '   Detect vector ( row, column) or square forms ( TBA determinant etc)
        r$ =""
        w =val( word$( in$, 1, ","))
        h =val( word$( in$, 2, ","))
        if w =h then r$ ="  Square" else r$ ="  Matrix"
        r$ =r$ +" size "; str$( w); " columns by "; str$( h); " rows."
        if w =1 then r$ =r$ +"  Column vector size "; str$( w); " by "; str$( h)
        if h =1 then r$ =r$ +"  Row vector  size "; str$( w); " by "; str$( h)
                                        '   add detection of diagonal, determinant, etc...
        MatrixProperties$ =r$
    end function

    function ScaleMatrix$( scalar, in$) '   Scalar product
        w =val( word$( in$, 1, ","))
        h =val( word$( in$, 2, ","))
        prod$ =str$( w); ","; str$( h); ","
        for i =1 to h
            for j =1 to w
                term$   =word$( in$, 2 +j +( i -1) *w, ",")
                tv      =scalar *eval( term$)
                res$    =str$( tv)
                prod$   =prod$ +res$ +","
            next j
        next i
        ScaleMatrix$ =prod$ '   ############## trailing ',' to remove. It is however harmless.
    end function

    function MatrixTranspose$( in$)
        w =val( word$( in$, 1, ","))
        h =val( word$( in$, 2, ","))
        t$ =str$( h); ","; str$( w); ","
        for i =1 to h
            for j =1 to w
                t$ =t$ +word$( in$, 2 +i +( j -1) *w, ",") +","
            next j
        next i
        MatrixTranspose$ =t$    '   ############## trailing ',' to remove
    end function


    sub DisplayMatrix in$   '   Display looking like a matrix!
        w =val( word$( in$, 1, ","))
        h =val( word$( in$, 2, ","))
        'print "Width = "; w; " & height ="; h
        for i =0 to h -1
            print "         |";
            for j =1 to w
                term$ =word$( in$, j +2 +i *w, ",")
                print using( "#####.#####", eval( term$)),
                '   This may not be a good general idea but aids readability
            next j
            print "|"
        next i
        '   print
    end sub


    '   ------------------------------------------------------------------
    '   In development, below here...

    function MatrixMultiply$( inA$, inB$)

        AColumn =val( word$( inA$, 1, ","))          '   This holds number of COLUMNs
        ARow    =val( word$( inA$, 2, ","))          '                        ROWs

        BColumn =val( word$( inB$, 1, ","))
        BRow    =val( word$( inB$, 2, ","))

        if ( AColumn <>BRow) or ( ARow <>BColumn) then notice "Matrix dimensions unsuitable. Not conformable": end

        n$ =str$( ARow); ","; str$( BRow); ","

        for AnsRow =1 to AColumn
            for AnsColumn =1 to BColumn
                trm =0
                for i =1 to BColumn '3
                    j1   =GetTerm( inB$, i,         AnsRow)
                    j2   =GetTerm( inA$, AnsColumn, i     )
                    trm  =trm + j1 *j2
                next i
                n$ =n$ +str$( trm) +","
            next AnsColumn
        next AnsRow
        MatrixMultiply$ =n$ '   ############## trailing ',' to remove
    end function

    function MatrixToPower$( Mat$, n)
        if ( n <>int( n)) or ( n <0)                        then notice "Integer pos've powers only.": end
        if not( instr( MatrixProperties$( Mat$), "Square")) then notice "Has to be square.":           end

        dims =val( word$( Mat$, 1, ","))

        o$ =UnityMatrix$( dims)

        if n <>0 then
            for i =1 to n
                o$ =MatrixMultiply$( Mat$, o$)
            next i
        end if

        MatrixToPower$ =o$
    end function
