    
    '   ** DavidDrakeClock.bas  **
    
    
'Nixie Clock simulation
[setupWindow]
    nomainwin
    WindowWidth=350
    WindowHeight=80
    UpperLeftX=DisplayWidth-351
    UpperLeftY=DisplayHeight-160
    graphicbox #1.g, -1, -1, 355, 135
    open "Nixie Clock" for window_popup as #1
    #1.g "trapclose [q];setfocus;when leftButtonDown [q];when rightButtonDown [q]"
    #1.g "backcolor black;fill black;flush"


[makeNumerals]
    global m1,m2,d1,d2,y1,y2
    global sN1,sN2,mN1,mN2,hN1,hN2
    global y,gap,h1x,h2x,m1x,m2x,s1x,s2x
    global sec$,min$,hrs$
    'brightness levels for each numeral
    b$(0)="210 165 65"
    b$(1)="215 175 70"
    b$(2)="220 185 75"
    b$(3)="225 195 80"
    b$(4)="230 205 85"
    b$(5)="235 215 90"
    b$(6)="240 225 95"
    b$(7)="245 235 100"
    b$(8)="250 245 105"
    b$(9)="255 255 110"
    b$(10)="65 65 0"'this is the dim (off) brightness value
    'Numeral drawing using turtle graphics
    w$="up;north;"
    n$(0)=w$+"turn 90;go 10;down;north;turn -45;go 14;north;go 40;turn 45;go 14;turn 45;go 10;turn 45;go 14;turn 45;go 40;turn 45;go 14;turn 45;go 10"
    n$(1)=w$+"turn 90;go 15;down;north;go 60;"
    n$(2)=w$+"turn 90;go 34;up;turn 180;down;go 34;down;north;go 12;turn 48;go 40;north;go 12;turn -45;go 12;turn -45;go 12;turn -45;go 12"
    n$(3)=w$+"go 10;turn 135;down;go 12;turn -45;go 12;turn -45;go 13;north;go 15;turn -45;go 15;north;turn 22;go 26;north;turn -90;go 30;"
    n$(4)=w$+"turn 90;go 20;down;north;go 60;turn 210;go 40;north;turn 90;go 30"
    n$(5)=w$+"go 10;turn 135;down;go 12;turn -45;go 12;turn -45;go 13;north;go 18;turn -45;go 13;turn -45;go 12;turn -45;go 13;north;turn 7;go 32;turn 83;go 25"
    n$(6)=w$+"go 22;down;turn 180;go 12;north;turn 135;go 12;turn -45;go 12;turn -45;go 13;north;go 12;turn -45;go 13;turn -45;go 12;turn -45;go 13;north;turn 25;go 42;"
    n$(7)=w$+"turn 90;go 10;north;turn 17;down;go 62;north;turn -90;go 27"
    n$(8)=w$+"go 22;down;turn 180;go 12;north;turn 135;go 12;turn -45;go 12;turn -45;go 13;north;go 12;turn -45;go 13;turn -45;go 12;turn -45;go 13;up;north;go 30;down;turn 180;go 12;north;turn 135;go 12;turn -45;go 12;turn -45;go 13;north;go 12;turn -45;go 13;turn -45;go 12;turn -45;go 13;"
    n$(9)=w$+"go 51;down;turn 180;go 12;north;turn 135;go 12;turn -45;go 12;turn -45;go 13;north;go 12;turn -45;go 13;turn -45;go 12;turn -45;go 13;up;north;turn 113;go 32;down;north;turn 205;go 42;"

[startTick]
    q=gDT(1)'get current time and date values
    y=70 'vertical position in box
    gap=45 'space between numerals
    h1x=20 'horizontal starting position in box
    h2x=h1x+gap 'hour numeral 2 position
    m1x=h2x+gap+20 'minute numeral 1 position
    m2x=m1x+gap 'minute numeral 2 position
    s1x=m2x+gap+20 'seconds numeral 1 position
    s2x=s1x+gap 'seconds numeral 2 position

    'clear screen and sets initial view of numerals
    #1.g "cls"
    for a = 0 to 9
        q=pN(a,hN1,h1x)
        q=pN(a,hN2,h2x)
        q=pN(a,mN1,m1x)
        q=pN(a,mN2,m2x)
        q=pN(a,sN1,s1x)
        q=pN(a,sN2,s2x)
    next a
    q=sC(10,5)'put colons between hour,minute,seconds
    #1.g "flush"
    timer 1000, [tick]

[tick]
    q=gDT(1)
    #1.g "place ";s1x-1;" ";y+2;";color black;boxfilled ";s1x+gap*2;" ";y-69'covers seconds with a black box to reduce flicker
    for a = 0 to 9
        if sec$="00" and min$="00" then 'update only when it changes to reduce flicker
            q=pN(a,hN2,h2x)
        end if
        if sec$="00" then  'update only when it changes to reduce flicker
            q=pN(a,mN1,m1x)
            q=pN(a,mN2,m2x)
        end if
        q=pN(a,sN1,s1x)
        q=pN(a,sN2,s2x)
    next a
    if sec$="00" or sec$="01" or sec$="30" or sec$="31" then 'every 30 seconds show the date for 2 seconds
        #1.g "cls"
        for a = 0 to 9
            q=pN(a,m1,h1x)
            q=pN(a,m2,h2x)
            q=pN(a,d1,m1x)
            q=pN(a,d2,m2x)
            q=pN(a,y1,s1x)
            q=pN(a,y2,s2x)
        next a
        q=sC(5,10)'put slashes between month,day,year
        timer 2000, [startTick]
    end if
    wait

[q]
    #1.g "cls"
    close #1
    end

function pN(z,hN,nx) 'put numerals on the window
    if hN=z then #1.g "color ";b$(z);";size ";z/4+2.5;";" else #1.g "color ";b$(10);";size 1;"
    #1.g "place ";nx+z;" ";y;";";n$(z)
end function

function sC(m,n) 'put slashes or colons numbers
        s$=";color "+b$(m)+";size 3;north;turn 22;go 56"
        c$=";color "+b$(n)+";size 1;circle 3"
        #1.g "place ";m1x-23;" ";y-4;s$
        #1.g "place ";s1x-23;" ";y-4;s$
        #1.g "place ";m1x-16;" ";y-41;c$
        #1.g "place ";m1x-16;" ";y-21;c$
        #1.g "place ";s1x-16;" ";y-41;c$
        #1.g "place ";s1x-16;" ";y-21;c$
end function

function gDT(n)'get date, time and values into variables
    sec$=right$(time$(),2)
    min$=mid$(time$(),4,2)
    hrs$=left$(time$(),2)
    sN1=val(left$(sec$,1))
    sN2=val(right$(sec$,1))
    mN1=val(left$(min$,1))
    mN2=val(right$(min$,1))
    hN1=val(left$(hrs$,1))
    hN2=val(right$(hrs$,1))
    m1=val(mid$(date$("mm/dd/yyyy"),1,1))
    m2=val(mid$(date$("mm/dd/yyyy"),2,1))
    d1=val(mid$(date$("mm/dd/yyyy"),4,1))
    d2=val(mid$(date$("mm/dd/yyyy"),5,1))
    y1=val(mid$(date$("mm/dd/yyyy"),9,1))
    y2=val(mid$(date$("mm/dd/yyyy"),10,1))
end function
