    
    '   ** AndyAmayaLEDclock.bas  **
    
    
' App Title: LED Function Demo
'Programmer: Andy Amaya
'     Date: October 27, 2003
NoMainWin:Randomize Time$("ms")/86400000
WindowWidth=800:WindowHeight=600
UpperLeftX=(DisplayWidth-WindowWidth)/2
UpperLeftY=(DisplayHeight-WindowHeight)/2
Dim clr$(10):For x = 1 To 10: Read x$: clr$(x)=x$: Next x
Data "128 160 255","red","255 212 64","blue","green","cyan","255 128 32","pink","192 255 0","white"
Open "LED Functions" For graphics_nsb As #g
#g,"Down; Trapclose [done]; BackColor 0 0 0; Fill 0 0 0"
hwinDC=GetDC(hWnd(#g)): Call SetBkMode hwinDC, 1
[Begin]
#g,"Setfocus": Gosub [AllDigits]: Scan
#g,"when characterInput [nex1]; when leftButtonDown [nex1]; when rightButtonDown [nex2]"
Wait
[nex1]
#g,"Setfocus": Gosub [RandomDigits]: Scan
#g,"when characterInput [nex2]; when leftButtonDown [nex2]; when rightButtonDown [Begin]"
Wait
[nex2]
#g,"Setfocus": Gosub [LEDClock]: Scan
#g,"when characterInput [Begin]; when leftButtonDown [Begin]; when rightButtonDown [nex1]"
Wait

[done]
Call ReleaseDC hWnd(#g),hwinDC: #g,"Cls":Close #g:End

[AllDigits]
#g,"Cls;Color white":Call text 350,12,"Scalable LED's"
Call text 257,32,"Left click to proceed ... Right click to go back"
For pen=0 To 5
    wide=(pen+1)*4:high=wide/4:xLED=(800-(30*wide+10*high))/2
    For i=0 To 9
     #g,"Color ";clr$(Rand(1,10))
     Call LED xLED+i*(3*wide+high+pen+1)-24,3*wide*pen+40,i,pen+1,pen+1
    Next i
Next pen
#g,"Flush;Segment segNum;Delsegment ";segNum-1
Return

[RandomDigits]
#g,"Cls;Color white":Call text 326,12,"Random Number LEDs"
Call text 257,32,"Left click to proceed ... Right click to go back"
clrCount=clrCount+1:If clrCount>10 Then clrCount=1
exitFlag=0:newColor$=clr$(clrCount):#g,"Color ";newColor$
[digitLoop]
If msTimer<Time$("ms") Then
    msTimer=Time$("ms")+60:num$=Str$(Rand(111111,999999)):ln=Len(num$)
    #g,"Color black;BackColor black;Place 204 250;BoxFilled 600 350;Color ";newColor$
     For i=1 To ln
        dig=Asc(Mid$(num$,i,1))-48:Call LED 204+i*48,250,dig,4,2
     Next i
End If
#g,"SetFocus;when leftButtonDown [nex2];when rightButtonDown [Begin]"
Scan:Goto [digitLoop]
#g,"Flush;Segment segNum;Delsegment ";segNum-1
Return

[LEDClock]
wide=16:high=wide/4:xTime=(800-(18*wide+8*high))/2
yTime=(600-(6*wide-high))/2:#g,"Cls;Color 255 255 255"
Call text 335,12,"Old Skool LED clock"
Call text 257,32,"Left click to proceed ... Right click to go back"
r=70:g=70:b=70:#g,"Color ";r;" ";g;" ";b:inc=5:colr=r
For i=0 To 84
    Call SuperEllipse 400,304,184+i,74+i,3,36,2,0:colr=colr+inc
    If colr>255 Then inc=inc*-1:colr=colr+inc
    r=colr:g=g+inc:b=b+inc:#g,"Color ";r;" ";g;" ";b
Next i
#g,"Color blue":Call text 309,412,Chr$(34)+"LED Clock"+Chr$(34)+" by Andy Amaya"
[clockLoop]
If sysTime$<>Time$() Then
    sysTime$=Time$()
    #g,"Color 0 0 0;BackColor 0 0 0;Place 250 254;BoxFilled 552 347;Color green"
    x=xTime:y=yTime:wide=16:high=4
    hr1=Val(Mid$(sysTime$,1,1)):hr2=Val(Mid$(sysTime$,2,1))
    mn1=Val(Mid$(sysTime$,4,1)):mn2=Val(Mid$(sysTime$,5,1))
    sc1=Val(Mid$(sysTime$,7,1)):sc2=Val(Mid$(sysTime$,8,1))
    Call LED x,y,hr1,4,2:x=x+3*wide
    Call LED x,y,hr2,4,2:x=x+3*wide+high
    Call Oval x,y+2*wide,high,high,2,0,4
    Call Oval x,y+4*wide+high/2,high,high,2,0,4:x=x+3*high
    Call LED x,y,mn1,4,2:x=x+3*wide
    Call LED x,y,mn2,4,2:x=x+3*wide+high
    Call Oval x,y+2*wide,high,high,2,0,4
    Call Oval x,y+4*wide+high/2,high,high,2,0,4:x=x+3*high
    Call LED x,y,sc1,4,2:x=x+3*wide
    Call LED x,y,sc2,4,2
End If
#g,"Flush;Segment segNum;Delsegment ";segNum-1:Scan
#g,"when characterInput [Begin];when leftButtonDown [Begin];when rightButtonDown [nex1]"
Goto [clockLoop]
Return

Function Rand(lo,hi)
Rand=int(rnd(0)*(hi-lo+1)+lo)
End Function

SUB LED x, y, digit, ledSize, penSize
If ledSize<.5 Then ledSize=.5
wide=ledSize*4.0:high=wide/4.0
If digit>=10 Then digit=digit-Int(digit/10)*10
If penSize<1 Then penSize=1
#g,"Size ";penSize
Select digit
Case 0
Call Oval x+wide+high,y+2*high,wide,high,penSize,0,6
Call Oval x+high,y+2*wide-high,wide,high,penSize,90,6
Call Oval x+2*wide+high,y+2*wide-high,wide,high,penSize,90,6
Call Oval x+high,y+4*wide+high,wide,high,penSize,90,6
Call Oval x+2*wide+high,y+4*wide+high,wide,high,penSize,90,6
Call Oval x+wide+high,y+5*wide+2*high,wide,high,penSize,0,6
Case 1
Call Oval x+wide+high,y+2*wide-high,wide+high/4,high,penSize,90,6
Call Oval x+wide+high,y+4*wide+3*high/2,wide+3*high/2,high,penSize,90, 6
Case 2
Call Oval x+wide+high,y+2*high,wide,high,penSize,0,6
Call Oval x+2*wide+high,y+2*wide-high,wide,high,penSize,90,6
Call Oval x+wide+high,y+3*wide,wide,high,penSize,0,6
Call Oval x+high,y+4*wide+high,wide,high,penSize,90,6
Call Oval x+wide+high,y+5*wide+2*high,wide,high,penSize,0,6
Case 3
Call Oval x+wide+high,y+2*high,wide,high,penSize,0,6
Call Oval x+2*wide+high,y+2*wide-high,wide,high,penSize,90,6
Call Oval x+wide+high,y+3*wide,wide,high,penSize,0,6
Call Oval x+2*wide+high,y+4*wide+high,wide,high,penSize,90,6
Call Oval x+wide+high,y+5*wide+2*high,wide,high,penSize,0,6
Case 4
Call Oval x+high,y+2*wide-high,wide,high,penSize,90,6
Call Oval x+2*wide+high,y+2*wide-high,wide,high,penSize,90,6
Call Oval x+wide+high,y+3*wide,wide,high,penSize,0,6
Call Oval x+2*wide+high,y+4*wide+3*high/2,wide+3*high/2,high,penSize,90,6
Case 5
Call Oval x+wide+high,y+2*high,wide,high,penSize,0,6
Call Oval x+high,y+2*wide-high,wide,high,penSize,90,6
Call Oval x+wide+high,y+3*wide,wide,high,penSize,0,6
Call Oval x+2*wide+high,y+4*wide+high,wide,high,penSize,90,6
Call Oval x+wide+high,y+5*wide+2*high,wide,high,penSize,0,6
Case 6
Call Oval x+high,y+2*wide-high,wide,high,penSize,90,6
Call Oval x+wide+high,y+3*wide,wide,high,penSize,0,6
Call Oval x+high,y+4*wide+high,wide,high,penSize,90,6
Call Oval x+2*wide+high,y+4*wide+high,wide,high,penSize,90,6
Call Oval x+wide+high,y+5*wide+2*high,wide,high,penSize,0,6
Case 7
Call Oval x+wide+high,y+2*high,wide,high,penSize,0,6
Call Oval x+2*wide+high,y+2*wide-high,wide,high,penSize,90,6
Call Oval x+2*wide+high,y+4*wide+3*high/2,wide+3*high/2,high,penSize,90,6
Case 8
Call Oval x+wide+high+pen,y+2*high,wide,high,penSize,0,6
Call Oval x+high+pen,y+2*wide-high,wide,high,penSize,90,6
Call Oval x+2*wide+high+pen*2,y+2*wide-high,wide,high,penSize,90,6
Call Oval x+wide+high+pen*2,y+3*wide,wide,high,penSize,0,6
Call Oval x+high+pen*2,y+4*wide+high,wide,high,penSize,90,6
Call Oval x+2*wide+high+pen*2,y+4*wide+high,wide,high,penSize,90,6
Call Oval x+wide+high+pen,y+5*wide+2*high,wide,high,penSize,0,6
Case 9
Call Oval x+wide+high,y+2*high,wide,high,penSize,0,6
Call Oval x+high,y+2*wide-high,wide,high,penSize,90,6
Call Oval x+2*wide+high,y+2*wide-high,wide,high,penSize,90,6
Call Oval x+wide+high,y+3*wide,wide,high,penSize,0,6
Call Oval x+2*wide+high,y+4*wide+3*high/2,wide+3*high/2,high,penSize,90,6
End Select
End SUB
SUB Oval centerX,centerY,wide,high,penSize,rotAngle,sides
pi2=Atn(1)*8.0:d2r=pi2/360.0:interval=360.0/sides
If interval<=0.0 Or interval>180.0 Then interval=1.0
interval=d2r*interval:rotAngle=d2r*rotAngle
If penSize<1 Then penSize=1
If rotAngle=0 Then
    x1=wide+centerX:y1=centerY:#g,"Place ";x1;" ";y1
    For i=interval To pi2 STEP interval
     x2=Cos(i)*wide+centerX:y2=Sin(i)*high+centerY:#g,"Goto ";x2;" ";y2
    Next i
Else
    cs=Cos(rotAngle):sn=Sin(rotAngle):x1=cs*wide+centerX:y1=sn*wide+centerY
    #g,"Place ";x1;" ";y1
    For i=interval To pi2 STEP interval
     rotX=Cos(i)*wide:rotY=Sin(i)*high
     x2=cs*rotX-sn*rotY+centerX:y2=sn*rotX+cs*rotY+centerY:#g,"Goto ";x2;" ";y2
    Next i
End If
End SUB
Sub SuperEllipse centerX,centerY,wide,high,exponent,numSegments,penSize,rotAngle
pi2=Atn(1)*8.0:d2r=pi2/360.0
If penSize<1 Or penSize>400 Then penSize=1
#g,"Size ";penSize
If exponent<.15 Then exponent=.15
If exponent>99 Then exponent=99
If exponent=0 Then power=0 Else power=2/exponent-1
If rotAngle>=360 Then rotAngle=rotAngle-Int(rotAngle/360)*360
inc=360.0/numSegments*d2r:rotAngle=d2r*rotAngle
If rotAngle=0 Then
    x1=wide+centerX:y1=centerY
    #g,"Place ";x1;" ";y1:limit=pi2+inc
    For theta=inc To limit STEP inc
     cosTheta=Cos(theta):sinTheta=Sin(theta)
     x2=wide*cosTheta*Abs(cosTheta)^power+centerX
     y2=high*sinTheta*Abs(sinTheta)^power+centerY:#g,"Goto ";x2;" ";y2
    Next theta
Else
    cs=Cos(rotAngle):sn=Sin(rotAngle):rotX=wide
    x1=cs*rotX+centerX:y1=sn*rotX+centerY
    #g,"Place ";x1;" ";y1:limit=pi2+inc
    For theta=inc To limit STEP inc
     cosTheta=Cos(theta):sinTheta=Sin(theta)
     rotX=cosTheta*wide*Abs(cosTheta)^power
     rotY=sinTheta*high*Abs(sinTheta)^power
     x2=cs*rotX-sn*rotY+centerX
     y2=sn*rotX+cs*rotY+centerY:#g,"Goto ";x2;" ";y2
    Next theta
End If
End Sub
Function GetDC(hWnd)
CallDLL #user32, "GetDC", hWnd As Long, GetDC As Long
End Function
Sub ReleaseDC hWnd, hDC
CallDLL#user32,"ReleaseDC", hWnd As Long, hDC As Long, result As Long
End Sub
Sub SetBkMode hDC, bkndFlag
CallDLL #gdi32, "SetBkMode", hDC As Long, bkndFlag As Long, RESULT As Long
End Sub
Sub text x,y,msg$
#g,"Place ";x;" ";y;";|";msg$
End Sub
' r
