
    '   ******************************************************
    '   **                                                  **
    '   **         Ogham messages-       ogham5.bas         **
    '   **                                                  **
    '   **      tenochtitlanuk           Nov 30 2020        **
    '   **                                                  **
    '   ******************************************************


    nomainwin

    WindowWidth  = 950
    WindowHeight = 650

    textbox     #w.tb1,530, 460, 400,  30

    graphicbox  #w.gg,  40,   5, 160, 200
    graphicbox  #w.g0,  35, 232, 160, 345
    graphicbox  #w.g1, 255,   5, 144, 576
    graphicbox  #w.g2, 420,   5,  70, 576
    graphicbox  #w.g3, 620, 205, 212,  47

    button      #w.b1, "New Text",     [newText], LR,  250, 278, 80, 40
    button      #w.b2, "Save graphic", [saveGr],  LR,  150,  78, 80, 40

    statictext  #w.st1, "", 550,  20, 380, 160
    statictext  #w.st2, "", 560, 390, 380,  60


    open "Ogham writer" for window as #w

    #w "trapclose quit"

    CR$ =chr$( 10)
    #w.st1 "You can find a lot about Ogham writing on Wikipedia"        +CR$ +CR$ +_
              "I am using here a simplified phonetic version"           +CR$ +CR$ +_
              "'New Text' asks for new word or message."                +CR$ +CR$ +_
              "'Save graphic' saves the message as a BMP"

    #w.st1 "!font 12"
    #w.st2 "!font Courier bold 14"

    #w.tb1 "!font Courier bold 16"

    #w.st2 "New source here. '_'for spaces." +chr$( 10) +chr$( 10) +" Only Runic 'letter's or 'pairs'" +chr$( 10) +"          eg 'H,O,P,'"

    loadbmp "scr", "stone.bmp"
    #w.gg "down ; drawbmp scr 1 1 ; flush"

    loadbmp "scr", "OghamPillar.bmp"
    #w.g0 "down ; drawbmp scr 1 1 ; flush"

    loadbmp "scr", "Ogham.bmp"
    #w.g1 "down ; drawbmp scr 1 1 ; flush"

    #w.g2 "down ; fill 150 150 150 ; flush"

    loadbmp "scr", "mailagni2.bmp"
    #w.g3 "down ; drawbmp scr 1 1 ; flush"

    gn =1
    for x =0 to 1
        for y =0 to 14
            xScr = 0 +x *70 +6
            yScr =12 +y *35
            if ( 15 *x +y) <27 then
                #w.g1 "getbmp scr" +right$( "00" +str$( gn), 2) +" "; xScr; " "; yScr; " 36 38"
                ' for testing- save bmps
                bmpsave "scr" +right$( "00" +str$( gn), 2), "glyphs/" +right$( "00" +str$( gn), 2) +".bmp"
            end if
            gn =gn +1
        next y
    next x

    for i =1 to 10
        #w.g2 "drawbmp scr" +right$( "00" +str$( i), 2) +" 10 " +str$( 20 *i)
    next i

    letter$ ="H 01,D 02,T 03,C 04,Q 05,A 06,O 07,U 08,E 09,I 10,B 11,L 12,"+_
    "F 13,S 14,N 15,M 16, G 17,NG 18,Z 19,R 20,P 21,EA 22,OI 23,UI 24,IA 25,AE 26,_ 27, "
    'source$ ="D,A,F,I,D,"
    'source$ ="L,I,B,E,R,T,I,R,U,L,E,S,"
    source$ ="M,A,I,L,A,G,N,I,"

    #w.tb1, source$ 

    gosub [firstRun]

    wait

  [newText]
    #w.tb1 "!contents? source$"
    source$ =upper$( source$)
    for L =1 to len( source$)
        g$      =word$( source$, L, ",")
        'if g$ ="_ " then [pass]
        if instr( letter$, g$ +" ") =0 then
            #w.tb1 "Invalid input"

            timer 1000, [k]
            wait
          [k]
            timer 0

            #w.tb1 ""
            exit for
        end if
        '[pass]
    next L

  [firstRun]
    #w.g2 "fill 150 159 150"
    for j =1 to len( source$) /2    '   allow for the separators in the length
        e$      =word$( source$, j, ",")
        n       =instr( letter$, e$)
        N       =val( mid$( letter$, n +2))
        if e$ <> "_ " then
            #w.g2 "drawbmp scr" +right$( "00" +str$( N), 2) +" 10 " +str$( 570 -38 *j)
        else
            #w.g2 "drawbmp scr27 10 " +str$( 570 -38 *j)
        end if
    next j

    #w.g2 "color 150 150 150 ; size 5 ; up ; goto 28 10 ; down ; goto 28 560"

    #w.g2 "flush"

    wait

  [saveGr]
    #w.g2 "getbmp scr 1 1 1200 70"
    filedialog "Filename", "*.bmp", fn$
    bmpsave "scr", fn$ +".bmp"
    wait

    sub quit h$
        close #w
        end
    end sub
