
'   #####################################################################################
'   ################                                               ######################
'   ################     Mandelbrot and Mandelbar examination...   ######################
'   ################                                               ######################
'   ################           tenochtitlanuk  Feb 2010            ######################
'   ################                                               ######################
'   #####################################################################################

'   To-dos-
'       Enable/disable options and buttons properly.
'       Save each higher resolution as a gif and create animated version of sequence.
'       Add a mouse-position selection box to allow zooming in..                                Started
'       Correct the exit/close failing from in subs.
'       Is there a way to make filedialog open with 'view as thumbnails'?
'       Change to plot squares rather than circles, and cornered from P, Q to P+d, Q-d          DONE
'       Need better graduated scales, concentrated near one end- or read non-linearly.
'       Need to save and reload appearance at each pass, and cls to avoid redraw error/flush
'       When type is changed, need to fill g2 with that fullscale fractal for region-choice.
'       Make so can repeat zoom and display.
'       Prevent second point of selected region being to left or below first. ?Marquee??


'                                           Remove the 'mainwindow' which we don't use
    nomainwin

'                                           Set size of window we want to open
    WindowWidth  =670
    WindowHeight =700
    UpperLeftX   = 10
    UpperLeftY   = 10
'                                           Set size and position of area we'll graph in
    graphicbox #w.g,   60,  70, 512, 512
'                                           Create graphicbox to hold colour range for look-up.
    graphicbox #w.g2, 200,  50, 256,  10
'                                           Put a debug window to show values in..
    textbox    #w.t,                   90, 600, 460,  20

    statictext #w.st1,   "( lx, uy)",  10, 590,  80,  40
    statictext #w.st2,   "( rx, ly)", 570,  40,  80,  40
    statictext #w.st3,   "",          210,  10, 350,  20

    button     #w.b,  "Run",  [bval],    LR, 40,  60,  60,  30
    button     #w.b2, "SaveBMP", [sav],  LR, 40,  90,  60,  30
    button     #w.b3, "Halt", [halt],    LR, 40, 120,  60,  30
    button     #w.b4, "Corners", [corn], LR, 40, 150,  60,  30
    button     #w.b5, "Unzoom", [unz],   LR, 40, 180,  60,  30

    menu       #w,    "Options and Help", "Colour range", colourRange, "Type", [type], |, "Help", [help]

'                                           Create rgb spec'n of 256 colours from a provided bmp gradient
    dim color$( 255)
'                                           A flag for whether Mandel-brot or -bar.
    type$ ="brot"

    type$( 0) = "brot"
    type$( 1) = "bar"
    type$( 2) = "brot3"
    type$( 3) = "bar3"
    type$( 4) = "brot6"

    global RangeFile$$, type$, lx, rx, uy, ly, dx, dy, z, iteration, d, it
'   ______________________________________________________________________________________________

'                                           open the window
    open "Complex plane- Argand diagram" for window as #w

'                                           Make sure clicking the close symbol works cleanly
    #w   "trapclose [quit]"
'
    #w.g  "down"
    #w.g2 "down"
'                                           Put the pens down in the graphicboxes for drawing

    loadbmp "plane", "plane2.bmp"
    #w.g    "drawbmp plane 1 1"
    #w.g    "flush"

    loadbmp "range", "range.bmp"
    #w.g2   "drawbmp range"
    #w.g2   "flush"

    #w.st1  "!font arial 10 bold"
    #w.st2  "!font arial 10 bold"
    #w.st3  "!font arial 12 bold"
    #w.st3  "Mandelbrot-  z <== z squared    +c"

    #w.t    "!font courier 4"
    #w.b3   "!disable"
'                                           Set range we're interested in mapping on our screen- edit to your liking..

    call getColValues

    lx =-2                                    '   Initially -2            try -2
    rx = 2                                    '   Initially  2            try -1.5
        dx =rx -lx
    uy =-2                                    '   Initially -2            try -0.1
    ly = 2                                    '   Initially  2            try  0.1
        dy =ly -uy

    #w.st1 "( "; str$( lx); ", "; str$( uy); ")"
    #w.st2 "( "; str$( rx); ", "; str$( ly); ")"

    d =512 /2

    wait

[bval]
    #w.g "cls"
'                                           We are interested in the range of x and y between limits
'                                               with 400 steps on each range
while d >=1
    #w.b  "!disable"
    #w.b3 "!enable"
    for x =lx to rx step dx /512 *d
        for y =uy to ly step dy /512 *d
            print d; "   "; x; "    "; y
'                                           c is the point we're checking, ( x =real and y =imag'y parts)
            xold = x                       'we keep using xold, yold to work out an xnew, ynew
            yold = y                       'starting at our chosen ( x, y) location

            for iteration =1 to 255        'Repeat for each ( x, y) up to 50 iterations

                select case type$

                case "brot"                     'Mandelbrot calc
                    xnew = xold^2  -yold^2 +x                           'Here's the real and imag'y bits of the z <==z^2 +c
                    ynew = 2 *xold *yold   +y

                case "bar"                      'Mandelbar calc
                    xnew = xold^2  -yold^2  +x                          'Here's the real and imag'y bits of the z <==zbar^2 +c
                    ynew = -2 *xold *yold   +y

                case "brot3"                    'Mandel3brot calc
                    xnew = xold^3 -xold *yold^2  -2 *xold *yold^2 +x    'Here's the real and imag'y bits of the z <==z^3 +c
                    ynew = 3 *xold^2 *yold +yold^3  +y

                case "bar3"                     'Mandel3bar calc
                    xnew = xold^3 +xold *yold^2  +x                     ' Here's the real and imag'y bits of the z <==zbar^3 +c
                    ynew = -1 *xold^2 *yold -yold^3 +y

                case "brot6"
                    xnew =xold^6 -15*xold^4 *yold^2 +15 *xold^2 *yold^4 -yold^6 +x
                    ynew =6 *xold^5 -20 *xold^3 *yold^3 +6 *xold *yold^5 +y

                end select

                z    = xnew^2 +ynew^2      'Calculate the radial distance from the origin
                                           'It's known that if this is >2^2 we're 'outside'
                xold = xnew
                yold = ynew

                if z >4 then it =iteration: exit for
            next iteration
'                                          'Choose colour
            if z <=4 then                  'We're definitely inside the set
                #w.g "color black ; backcolor black"
            else                           'It took 'iteration' repeats of the calc'n until we were clearly outside.
                'it =iteration
                #w.g "color ";     color$( it)
                #w.g "backcolor "; color$( it)
            end if
           P =512 *( x -lx) /dx              'P is a plotting position changing the range lx to rx into 0 to 400
           Q =511 -512 *( y -uy) /dy         '    and similarly range uy to ly into 0 to 400. ( y goes down screen)
'                                           Now plot the point
           #w.t " P=";    right$( "000" +str$( P), 3); "  Q=";   right$( "000" +str$( Q), 3); "  d=";   right$( "000" +str$( d), 3); "  col="; color$( it); " it="; it
           if d =1 then
                #w.g "set "; P; " "; Q
           else
                #w.g "up ; goto "; P-d/2;    " "; Q+ d/2;     " ; down"
                #w.g "boxfilled "; P +d/2; " ";   Q -d /2
           end if
'                                           Check if mouse or keyboard input- eg closing!!
           scan

    'timer 50, [o]               '   Un rem these lines to see how the drawing works.
           'wait
        [o]
           'timer 0
        next y
    next x
'                                           Flush the graphic so not erased by overlaying windows.
    '#w.g "up ; color black ; goto 200 200 ; down ; circle 200"
    #w.g "flush"

            #w.g "getbmp scr 1 1 511 511"
            f$ ="ani" +right$( "000" +str$( d), 3) +".bmp"
            bmpsave "scr", f$
    d =int( d /2)
wend


    wait

[unz]
    lx =-2 : rx = 2 : dx =rx -lx
    uy =-2 : ly = 2 : dy =ly -uy


    #w.st1 "( "; str$( lx); ", "; str$( uy); ")"
    #w.st2 "( "; str$( rx); ", "; str$( ly); ")"
    wait


[corn]
    #w.g "When leftButtonUp [c1]"
    wait
  [c1]
    lxnew =lx +MouseX /512 *( rx -lx)
    uynew =uy +MouseY /512 *( ly -uy)
    #w.st1 "( "; str$( lxnew); ", "; str$( uynew); ")"
    #w.g "When leftButtonUp [c2]"
    wait
  [c2]
    rxnew =lx +MouseX /512 *( rx -lx)
    lynew =uy +MouseY /512 *( ly -uy)
    if rxnew <=lxnew or uynew <=lynew then #w.g "When leftButtonUp [c2]": wait

    #w.st2 "( "; str$( rxnew); ", "; str$( lynew); ")"

    lx =lxnew:     uy =uynew
    rx =rxnew:     ly =lynew
    dx =rx -lx:    dy =ly -uy

    wait

Function KCGetPixel$( x, y)                             'x, y = window coordinates     Thanks KCDan!!
        #w.g2,  "Getbmp pixel "; x; " "; y; " 1 1"      'A 1x1 bitmap, contains exactly 1 pixel
        Bmpsave "pixel", "kcGetPixelData.datkc"         'Save that one pixel as a temporary bmp file
        Open "kcGetPixelData.datkc" for Binary as #kc   'Open that one pixel bmp file as a binary file
            Seek #kc, 66                                'Blue Info
            b =Asc( Input$( #kc, 1))                    'Blue
            Seek #kc, 67                                'Green Info
            g =Asc( Input$( #kc, 1))                    'Green
            Seek #kc, 68                                'Red Info
            r =Asc( Input$( #kc, 1))    'Red
        Close #kc
        Kill "kcGetPixelData.datkc"                     'Delete the temporary bmp file
        KCGetPixel$ =r; " "; g; " "; b                  'Place the values in a string
        #w.t KCGetPixel$
End Function

sub colourRange
    filedialog "Choose a colour range", "range*.bmp", RangeFile$
    if RangeFile$ ="" then
        RangeFile$ ="range.bmp"
    end if
    loadbmp "range", RangeFile$
    #w.g2 "drawbmp range"
    #w.g2 "flush"
    call getColValues
end sub

sub getColValues
    for v =0 to 255
        color$( v) =KCGetPixel$( v, 5)
     next v
end sub

[help]
    texteditor #h.t, 10, 10, 500, 400

    WindowWidth  =550
    WindowHeight =450

    open "Help & Information" for dialog_modal as #h

    #h.t "!font arial 12"
    #h.t ""
    #h.t "           Mandelbrots and Mandelbars"
    #h.t ""
    #h.t "You are looking at a region of the Argand diagram /complex plane."
    #h.t "On it, a point ( x, iy) represents a complex number z as a vector"
    #h.t ""
    #h.t "When you multiply these 'complex numbers' they behave as 'x +iy'"
    #h.t "Where i^2 =-1"
    #h.t "Remember ( a +b)^2 =a^2 +b^2 +2ab"
    #h.t "So if z were = 1.2 +0.5i, then z^2 =1.2^2 -0.25 +1.2i"
    #h.t "  ie z^2 =( 1.19 +1.2i)"
    #h.t ""
    #h.t "To check any given z for whether it is 'in the Mandelbrot set'"
    #h.t "  you keep squaring z and adding the original number, keeping track"
    #h.t "  of the real and imaginary parts."
    #h.t "This amounts to repeatedly rotating, scaling and shifting z"
    #h.t "If the amplitude ( |z| =( x^2 +y^2)^0.5) becomes >2 you are known"
    #h.t "  to be outside the set."
    #h.t "You plot a colour showing how many iterations it took to get >2"
    #h.t ""
    #h.t "If inside, plot in black."
    #h.t ""
    #h.t "For a Mandelbar, instead of squaring z and adding c repeatedly,"
    #h.t "  you square the 'complex conjugate' of z and add c repeatedly."
    #h.t ""
    #h.t "The drawing is done first coarsely, then increasingly higher resolutions."
    wait

[sav]
    #w.g "getbmp scr 1 1 511 511"
    filedialog "Choose a name to save screen", "screen*.bmp", f$
    if f$ ="" then
        f$ ="screen.bmp"
    end if
    bmpsave "scr", f$
    wait

[halt]
    #w.b  "!enable"
    #w.b3 "!disable"
    wait
    wait


wait

[type]
    listbox #type.lb, type$(),     selectionMade,              5, 35, 250, 90
    button  #type.b0,      "Cancel",   [cancelTypeSelection],   UR, 15, 5
    button  #type.b1,      "Continue", [selectionMade],         UL,  5, 5
    WindowWidth  = 270
    WindowHeight = 180

    open "Select a type" for window as #type

    #type.lb "singleclickselect"

     wait


[selectionMade]
    #type.lb, "selection? type$"
    if type$ ="brot"   then
        #w.st3 "Mandel2brot-   z <== z squared     +c"
        loadbmp "s", "mandbrot.bmp"
        #w.g "drawbmp s 1 1"
        #w.g "flush"
        unloadbmp( "s")
    end if
    if type$ ="bar"    then
        #w.st3 "Mandel2bar-    z <== z_bar squared +c"
        loadbmp "s", "mandbar.bmp"
        #w.g "drawbmp s 1 1"
        #w.g "flush"
        unloadbmp( "s")
    end if

    if type$ ="brot3"  then
        #w.st3 "Mandel3brot-   z <== z cubed       +c"
        loadbmp "s", "mand3bro.bmp"
        #w.g "drawbmp s 1 1"
        #w.g "flush"
        unloadbmp( "s")
    end if

    if type$ ="bar3"   then
        #w.st3 "Mandel3bar-    z <== z_bar cubed   +c"
        loadbmp "s", "mand3bar.bmp"
        #w.g "drawbmp s 1 1"
        #w.g "flush"
        unloadbmp( "s")
    end if

    if type$ ="brot6"  then
        #w.st3 "Mandel6brot-   z <== z_bar cubed   +c"
        'loadbmp "s", "mand6brot.bmp"
        '#w.g "drawbmp s 1 1"
        '#w.g "flush"
        'unloadbmp( "s")
    end if
    close #type
    wait


[cancelTypeSelection]
close #type
wait

[quit]
    'close #h
    close #w
    end

