
nomainwin

WindowWidth  =540
WindowHeight =560

graphicbox #w.gb1, 10, 10, 500, 500

global file$

open "Voronoi neighbourhoods" for window as #w

#w     "trapclose quit"
#w.gb1 "down ; fill 180 180 180 ; size 8"

filedialog "Open csv Voronoi data file ( 'Return' for new example.", "new.csv", file$
if file$ ="K:\new.csv" then gosub [makeFile]    '   NB make ssure an equivalent address exists- or change!!

sites =countDataRows( file$)

dim townX( sites), townY( sites), col$( sites)
Xmin =  100000000000
Xmax = -100000000000
Ymin =  100000000000
Ymax = -100000000000

open file$ for input as #r
    line input #r, Header$
    for i =1 to sites
        line input #r, line$
        townX( i) =val( word$( line$, 2, ","))
        townY( i) =val( word$( line$, 3, ","))
        if townX( i) < Xmin then Xmin = townX( i)
        if townX( i) > Xmax then Xmax = townX( i)
        if townY( i) < Ymin then Ymin = townY( i)
        if townY( i) > Ymax then Ymax = townY( i)
        col$( i) = str$( 50 +int( 206 *rnd( 1))); " "; str$( 50 +int( 206 *rnd( 1))); " "; str$( 50 +int( 206 *rnd( 1)))
    next i
close #r

dX =Xmax -Xmin: dY =Ymax -Ymin: dxy =max( dX, dY)

for i =1 to sites
    #w.gb1 "color black ; size 12"
    #w.gb1 "set "; 70 +( townX( i) -Xmin) /dxy *400; " "; 70 +( townY( i) -Ymin) /dxy *400

    #w.gb1 "color "; col$( i); " ; size 8"
    #w.gb1 "set "; 70 +( townX( i) -Xmin) /dxy *400; " "; 70 +( townY( i) -Ymin) /dxy *400
next i

#w.gb1 "getbmp scr 0 0 500 500"
bmpsave "scr", left$( file$, len( file$) -4) +"orig2.bmp"

#w.gb1 "size 1"

ratio =dxy /dY

for xS =-70 to 430
    for yS =-70 *ratio to 430 *ratio step ratio
        'find distance to all of the towns and hence closest; set colour pixel to its colour.
        distSqd =dxy^2 /50   '  4 *10^7   '   governs max radius of influence
        itIs =0
        for i =1 to sites
            nDistSqd =( townX( i) -( Xmin +xS /400 *dX))^2 +( townY( i) -( Ymin +yS /400 *dY))^2
            if nDistSqd <distSqd then itIs =i: distSqd =nDistSqd
        next i
        if distSqd <1000 then #w.gb1 "color black"
        if itIs <>0 then #w.gb1 "color "; col$( itIs) else #w.gb1 "color 100 100 100"
        #w.gb1 "set "; 68 +dX *xS /dxy; " "; 68 +dY *yS /dxy
        scan
    next yS
next xS

#w.gb1 "getbmp scr 0 0 500 500"
bmpsave "scr", left$( file$, len( file$) -4) +"Voronoi2b.bmp"

wait

sub quit w$
    close #w$
    end
end sub

function countDataRows( f$)
    open f$ for input as #inF
    content$ =input$( #inF, lof( #inF))
    for i =1 to len( content$)
        if mid$( content$, i, 1) =chr$( 13) then countDataRows =countDataRows +1
    next i
    close #inF
    countDataRows =countDataRows -1
end function

[makeFile]
    rows =int( 18 *rnd( 1)) +3
    open "new.csv" for output as #o
    #o "Loc'n, X, Y"
    X1 =int( 10000)
    Y1 =int( 10000)
    for j =1 to rows
        X =X1 +10000 *rnd( 1)
        Y =Y1 +10000 *rnd( 1)
        #o str$( j)+ ","+ str$( X)+ "," +str$( Y)
    next j
    close #o
return
