
    WindowWidth  = 830
    WindowHeight = 720
    UpperLeftX   =  50
    UpperLeftY   =   2

    graphicbox #w.gb1,    10,  40, 801, 601
    graphicbox #w.gb2,    10, 650, 260,  14

    statictext #w.st1, "",10,  10, 800,  24

    nomainwin

    dim zData( 500, 500)
    dim colour$( 255)

    open "TAUPO- display height( x, y)." for graphics_nsb_nf as #w

    #w "trapclose [quit]"
    #w.gb1 "down ; fill lightgray"

    loadbmp "scr", "palette0.bmp"
    #w.gb2 "down ; fill black ; drawbmp scr 0 1"

    #w.st1 "Calculating palette values"
    call getColValues

    open "tq3875nw.asc" for input as #inFile
    f =1

    #w.st1 "Reading height data"

    for i =1 to 6   '   read past the header lines
        line input #inFile, line$
    next i

    maxZ =0: minZ =1000
'1    _________________________________________________________________________
    for y =0 to 499
        line input #inFile, line$
        #w.st1 "Reading data row "; right$( "   " +str$( y), 3); " of 500."
        x    =0
        p    =1
        nxt$ =""
          [again]
            p$ =mid$( line$, p, 1)
            if p$ <>" " then nxt$ =nxt$ +p$: p =p +1: goto [again] else p =p +1
            zData( x, y) =int( val( nxt$))
            c =7 *zData( x, y)
            #w.gb1 "color "; c; " 255 "; 255 -c
            #w.gb1 "set "; 150 +x; " "; y +50
            maxZ =max( maxZ, zData( x, y))
            minZ =min( minZ, zData( x, y))
            x =x +1
        if x <=499 then nxt$ ="": goto [again]
        scan
    next y
    close #inFile
    f =0
    range =maxZ -minZ
    #w.gb1 "flush"
    #w.gb1 "getbmp scr 0 0 800 600"
    #w.st1  "scr screen1.bmp"
    bmpsave "scr", "screen1.bmp"

'2   ______________________________________________________________________________
    #w.st1 "Plotting height data- simple colours black <--> red"
    #w.gb1 "size 1"
    for y =0 to 499 step 1
        for x =0 to 499 step 1
            c =255 *(  zData( x, y) -minZ) /range
            #w.gb1 "color "; 255 -c; " 0 0"
            #w.gb1 "set "; 150 +x; " "; y +50
        next x
        scan
    next y
    #w.gb1 "flush"
    #w.gb1 "getbmp scr 0 0 800 600"
    #w.st1  "scr screen2.bmp"
    bmpsave "scr", "screen2.bmp"

'3   ______________________________________________________________________________
    #w.st1 "Plotting height data- using custom palette-range"
    #w.gb1 "size  1 ; color black"
    for y =0 to 499 step 1
        for x =0 to 499 step 1
            c =int( 255 *(  zData( x, y) -minZ) /range)
            #w.gb1 "color "; colour$( c)
            #w.gb1 "set "; 150 +x; " "; y +50
        next x
        scan
    next y
    #w.gb1  "flush"
    #w.gb1  "getbmp scr 0 0 800 600"
    bmpsave "scr", "screen3.bmp"

'4   ______________________________________________________________________________
    #w.st1 "Plotting height data in pseudo-3D in single colour"
    #w.gb1 "fill lightgray ; size 1 ; up ; goto 50 80 ; down"
    #w.gb1 "color black"
    for y =0 to 499 step 1
        for x =0 to 499 step 1
            c =int( 255 *(  zData( x, y) -minZ) /range)
            if ( x =0) or ( y >=498) then #w.gb1 "color black" else #w.gb1 "color "; 255 -c; " 0 "; c
            #w.gb1 "line "; 50 +x +y /2; " "; y /1.22 +300; " "; 50 +x +y /2; " "; y /1.2 +50 +7 *zData( x, y)
        next x
        scan
    next y
    #w.gb1 "flush"
    #w.gb1 "getbmp scr 0 0 800 600"
    bmpsave "scr", "screen4.bmp"

'5   ______________________________________________________________________________
    #w.st1 "Plotting in pseudo-3D with better colours"
    #w.gb1 "fill lightgray ; size 1 ; up ; goto 50 80 ; down"
    #w.gb1 "color white"
    for y =0 to 499 step 1
        for x =0 to 499 step 1
            c =int( 255 *(  zData( x, y) -minZ) /range)
            if ( x =0) or ( y >=498) then #w.gb1 "color black" else #w.gb1 "color "; colour$( c)
            #w.gb1 "line "; 50 +x +y /2; " "; y /1.2 +300; " "; 50 +x +y /2; " "; y /1.2 +50 +7 *zData( x, y)
        next x
        scan
    next y
    #w.gb1 "flush"
    #w.gb1 "getbmp scr 0 0 800 600"
    bmpsave "scr", "screen5.bmp"
    wait



'   ______________________________________________________________________________
[quit]
    close #w
    if f =1 then close #inFile
    end



'   ______________________________________________________________________________
Function KCGetPixel$( x, y)                                  'x, y = window coordinates     Thanks KCDan!!
        #w.gb2 "Getbmp pixel "; 1 +x; " "; 1 +y; " 1 1"      'A 1x1 bitmap, contains exactly 1 pixel
        '#w.gb2 "color black ; set "; x; " "; y
        Bmpsave "pixel", "kcGetPixelData.datkc"              'Save that one pixel as a temporary bmp file
        '#w.st1 "<"; KCGetPixel$; ">"
        Open "kcGetPixelData.datkc" for Binary as #kc        'Open that one pixel bmp file as a binary file
            Seek #kc, 54                                     'Blue Info
            b =Asc( Input$( #kc, 1))                         'Blue
            Seek #kc, 55                                     'Green Info
            g =Asc( Input$( #kc, 1))                         'Green
            Seek #kc, 56                                     'Red Info
            r =Asc( Input$( #kc, 1))    'Red
        Close #kc
        Kill "kcGetPixelData.datkc"                          'Delete the temporary bmp file
        KCGetPixel$ =str$( r); " "; str$( g); " "; str$( b)  'Place the values in a string
End Function

'   ______________________________________________________________________________
sub getColValues
    for v =0 to 255
        colour$( v) =KCGetPixel$( v, 3)
     next v
end sub
'   ______________________________________________________________________________
