WindowWidth = 544
WindowHeight =660

type$     ="log"

global gradient$
gradient$ ="repeat.bmp"
'gradient$ ="LinuxGimp24b.bmp"
'gradient$ ="grey.bmp"
'gradient$ ="fourCycles.bmp"

nomainwin

graphicbox #w.gb1, 20,  20, 500, 580

open "Laplace solution- slab & heat source(s)." for graphics_nsb_nf as #w

#w        "trapclose [quit]"

#w.gb1    "down ; fill lightgray"
loadbmp   "scr", gradient$
#w.gb1    "drawbmp scr 110 20"
unloadbmp "scr"

#w.gb1 "up ; goto 45 125 ; down ; color black ; backcolor black ; boxfilled 435 515"
#w.gb1 "backcolor lightgray ; font courier_new 15 bold"

#w.gb1 "up ; goto 104 15 ; down"
#w.gb1 "\Hot . . . . . . . Cold"
#w.gb1 "up ; goto 104 50 ; down"
if type$ ="log" then #w.gb1 "\.200 . 100 . 40 . 20 log scale." else #w.gb1 "\255 . . .120 . . . 10 lin scale."

#w.gb1 "flush"

dim slab1( 40, 40)

for x =0 to 40
    for y =0 to 40
        slab1( x, y) =0
    next y
next x

dim colour$( 255)

global n: n =0
global interval: interval =500

call getColValues

#w.gb1 "size 7"
for x =0 to 40
    for y =0 to 40
        if type$ ="lin" then #w.gb1 "color "; colour$( slab1( x.rand, y.rand)) else #w.gb1 "color "; colour$( int( 45.2 *( log( 1 +slab1( x.rand, y.rand)))))
        #w.gb1 "set "; 40 +x *10; " "; 520 -y *10
    next y
next x

call boundary
call saveBmp

timer 100, saveBmp

#w.gb1 "size 7"

for i =1 to 2000000
    [a]
    x.rand =int( 41 *rnd( 1))
    y.rand =int( 41 *rnd( 1))
    if ( x.rand >17 and x.rand <23) and ( y.rand >17 and y.rand <23) then [a]

    if x.rand <>0 and x.rand <>40 and y.rand <>0 and y.rand <>40 then
        average =0
        average =average +slab1( x.rand -1, y.rand) +slab1( x.rand +1, y.rand) +slab1( x.rand, y.rand -1) +slab1( x.rand, y.rand +1)
        average = average /4
        slab1( x.rand, y.rand) =average
    end if

    if type$ ="lin" then #w.gb1 "color "; colour$( slab1( x.rand, y.rand)) else #w.gb1 "color "; colour$( int( 45.2 *( log( 1 +slab1( x.rand, y.rand)))))
    #w.gb1 "set "; 40 +x.rand *10; " "; 520 -y.rand *10

    scan
next i

timer 0

IM$ ="convert +matte -resize 205x205 -delay 200 screens\scr*.bmp screens\anim.gif"
print IM$
run "cmd.exe /c "; chr$( 34); IM$; chr$( 34)    '   , HIDE
        '   Give it 30 seconds to execute (may not be enough for large images)
timer 30000, [on]
    wait
[on]
    timer 0
wait

end

sub saveBmp 'save whole screen so can cls and restore. Save sample to save.
    timer 0
    #w.gb1     "getbmp sca  0   0 500 580"
    #w.gb1     "getbmp sc  35 115 410 410"
    name$      ="screens\scr" +right$( "000" +str$( n), 3) +".bmp"
    bmpsave    "sc", name$
    n =n +1
    timer interval, saveBmp
    interval =interval *2
    #w.gb1     "cls"
    #w.gb1     "drawbmp sca 0 0"
    unloadbmp  "sc"
    unloadbmp  "sca"
end sub

sub getColValues    '   assumes it is a 24 bit bmp file.
'   some bmp files need you to change pointer to 54 ??if 32 bit
    open gradient$ for binary as #pixels
        pointer =54 '   66
        for v =0 to 255
            seek #pixels, pointer
            b =asc( input$( #pixels, 1))
            pointer =pointer +1

            seek #pixels, pointer
            g =asc( input$( #pixels, 1))
            pointer =pointer +1

            seek #pixels, pointer
            r =asc( input$( #pixels, 1))
            pointer =pointer +1

            colour$( 255 -v) =r; " "; g; " "; b
        next v
    close #pixels
end sub


sub boundary
    for i =0 to 40
        slab1( i,  0) =  0
        slab1( i, 40) =  0
        slab1( 0,  i) =  0
        slab1( 40, i) =  0
    next i

    for i =18 to 22
        for j =18 to 22
            slab1( i, j) =255
            if type$ ="lin" then #w.gb1 "color "; colour$( slab1( i, j)) else #w.gb1 "color "; colour$( int( 45 *( log( 1 +slab1( i, j)))))
            #w.gb1 "set "; 40 +i *10; " "; 520 -j *10
        next j
    next i
end sub

[quit]
close #w
end

