
    nomainwin

    WindowWidth  =680
    WindowHeight =680

    open "Display csv constellation file" for graphics_nsb as #wg
    open "Display wholesky"               for graphics_nsb as #wg2

    #wg "trapclose quit"
    #wg "cls ; down ; fill darkblue"
    #wg "color yellow"

    #wg2 "trapclose quit"
    #wg2 "cls ; down ; fill 150 150 150"
    #wg2 "color black"
    #wg2 "up ; goto 320 320 ; down ; circle 300"

    open "croppedRenamedPlusDummy.csv" for input as #fIn
        all$ =input$( #fIn, lof( #fIn))                             '   contains data for all stars of 48 constellations
    close #fIn

    L =len( all$)                                                   '   length of data file

    dim  star$( 100), az( 100), al( 100), br( 100)                  '   will hold name, azimuth, altitude and brightness of each star

    read constNum

    data 48                                                       '   in case we wish to produce all 48 in turn

    for con =1 to constNum
        read constellation$
        n       =0                                                  '   index for array of star data
        m       =instr( all$, constellation$)                       '   position of first relevant line of data
        mT      =m
        maxX    =-1000: minX =1000: maxY =-1000: minY =1000         '   will hold max and min al and az for stars in constellation being viewed
                                                                    '       re-initialize for each constellation
        do
            w$      =""
            do
                c$      =mid$( all$, mT, 1)
                w$      =w$ +c$
                mT      =mT +1
            loop until c$ =chr$( 10)

            w$      =left$( w$, len( w$) -1)

            if ( len( w$) <4) then exit do                          '   file finished

            if left$( w$, len( constellation$)) =constellation$ then '   Use only  data for constellation$
                star$( n)   =word$( w$, 1, ",")

                br          =val( word$( w$, 2, ","))
                br( n) =br '   br always <6.5 ( too dim) but not <1

                az          =val( word$( w$, 3, ","))
                az( n)      =az
                if az >maxX then maxX =az
                if az <minX then minX =az

                al          =val( word$( w$, 4, ","))
                al( n) =al
                if al >maxY then maxY =al
                if al <minY then minY =al

                n           =n +1
            else
                exit do
            end if

            scan
[skip] loop until 0

        #wg "cls ; down ; fill darkblue"
        #wg "color yellow"

        '#wg2 "color "; int( con *5); " "; int( 255 -con *5); " 0"


        baseWidth =500

        for i =0 to n -1
            'if constellation$ ="Orion" then print i, star$( i), az( i), al( i), br( i)
            '#wg "size "; int( 2 +3 *( 7 -br( i)))
            #wg "up ; goto 250 20 ; down ; color yellow ; backcolor darkblue"
            #wg "\"; constellation$

            mag             =min( int( 60 *( 6.6 -br( i))), 255)
            #wg "backcolor "; mag; " 0 0"

            scaleFactor     =1      'cosRad( az( i))
            offset          =-20    'scaleFactor *baseWidth /2

            screenX         =int( 570 -offset  -scaleFactor *500 *( az( i) -minX) /(maxX -minX))
            screenY         =int( 570                       -500 *( al( i) -minY) /(maxY -minY))

            #wg "up ; goto "; screenX; " "; screenY
            #wg "down ; circlefilled "; int( 2 +3 *( 7 -br( i)))

            radius      =270 +int( al( i) *3)'was 300 +int(
            angle       =270 +int( az( i))
            #wg2 "size "; int( 1 +( 6.5 -br( i)))  '   <<<<<<<<<<<<<<<<<<

            select case constellation$
                case "Orion"
                    #wg2 "color red"
                case "Ara"
                    #wg2 "color green"
                case "Crater"
                    #wg2 "color cyan"
                case "Hydra"
                    #wg2 "color white"
                case "Eridanus"
                    #wg2 "color yellow"
                case "Gemini"
                    #wg2 "color 255 50 200"
                case "Aquarius"
                    #wg2 "color blue"
                case "Pisces"
                    #wg2 "color white"
                case else
                    #wg2 "color black"
            end select

            '#wg2 "color "; int( 256+rnd(1)); " "; int( 256+rnd(1)); " "; int( 256+rnd(1))

            'if br( i) <4.6 then
                #wg2 "set "; 320 +radius *sinRad( angle); " "; 320 +radius *cosRad( angle)
            'end if

        next i

        #wg "flush ; getbmp scr 1 1 670 670"
        'CallDLL #kernel32, "Sleep", 10000 As ulong, Sleep As void
        'bmpsave "scr", "all2/correctedB" +constellation$ +".bmp"
        #wg2 "flush ; getbmp scr 1 1 670 670"
        bmpsave "scr", "wholeSky.bmp"
        'if constellation$ ="Orion" then wait    '   <<<<<<<<<<<<<<<<<<<<<

    next con

    wait

    function cosRad( th)
        cosRad =cos( th *3.14159265 /180)
    end function


    function sinRad( th)
        sinRad =sin( th *3.14159265 /180)
    end function

    sub quit h$
        close #wg
        close #wg2
        end
    end sub

data "Andromeda"
data "Aquila"
data "Aquarius"
data "Ara"
data "Arg"
data "Ari"
data "Auriga"
data "Bootes"
data "Capricornus"
data "Cassiopeia"
data "Centaurus"
data "Cepheus"
data "Cetus"
data "CanisMajor"
data "CanisMinor"
data "Cnc"
data "CoronaBorealis"
data "Crater"
data "Crux"
data "Corvus"
data "Cygnus"
data "Delphinus"
data "Draco"
data "Eridanus"
data "Gemini"
data "Hercules"
data "Hydra"
data "Inf"
data "Leo"
data "Lepus"
data "Libra"
data "Lupus"
data "Lyra"
data "Ophiuchus"
data "Orion"
data "Pegasus"
data "Perseus"
data "PsA"
data "Pisces"
data "Scorpius"
data "Serpens"
data "Sge"
data "Sagittarius"
data "Taurus"
data "Triangulum"
data "UrsaMajor"
data "UrsaMinor"
data "Virgo"
