
    'wavshower and analyser

    '   Takes an eight bit mono wav file & displays whole trace.
    '   You can select bits to enlarge & analyse


    nomainwin

    WindowWidth     = 790
    WindowHeight    = 670
    UpperLeftX      =   1
    UpperLeftY      =   1

    f  = 2'     y scaling factor
    t1 =46

    dim ampSin( 1000000), ampCos( 1000000), amp( 1000000)

    graphicbox #h.g,   10,   4, 700, 370
    graphicbox #h.g2,  10, 420, 700,  90
    graphicbox #h.g3,  10, 520, 700,  90

    textbox    #h.t1, 720,  52,  30,  20
    textbox    #h.t4,  50, 375,  90,  20
    textbox    #h.t5, 603, 375,  90,  20
    textbox    #h.t6,  10, 395,  90,  20
    textbox    #h.t7, 623, 395,  90,  20

    statictext    #h.st8, "", 140, 375, 465,  20
    statictext    #h.st9, "", 140, 395, 480,  20

    button     #h.b1, "y Gain +",   [scaleup],      UR,  10,  20
    button     #h.b2, "y Gain -",   [scaledown],    UR,  10,  80

    button     #h.b3, "Draw",       [ShowData],     LL, 730,  90


    open "CRO display & Fourier Analysis- for 8bit mono 11025 Hz sampling wav files" for window_nf as #h

    #h "trapclose [quit]"

    #h.b3 "!disable"

    #h.st8, "File is displayed below and played. Mouse left-clicks on this choose 0.1 sec sample start."
    #h.st9, "You may want to choose a different vertical ( y) gain. Click 'Draw' to analyse."

    filedialog "Open file to view", "Houston8.wav", currentFile$
        ' I am only bothering with 8bit mono- could easily adapt to other wavs
    open currentFile$ for input as #f
    playwave currentFile$, async
    Le =lof( #f)
    t2 =Le

    #h.t6, "Start=46"
    #h.t7, "End ="; Le

    i$ =input$( #f, Le)'    i$ now holds a memory resident copy of the wav file

    #h.t1, f
    #h.g2, "when  leftButtonDown [limit1]"


    #h.g2, "cls ; down ; fill darkgray ; color green ; line 700 100  0 100 ; flush"

    #h.g3 "down"

    for x = 46 to Le step int( (Le-46)/20000)
        x$ =mid$( i$, x, 1)
        v  =asc( x$) -128'   0 (-127) to 255 (+127) with 128 as zero
        #h.g2, "set "; (x-45)/Le*700; " ";  45 +v/3
    next x
    #h.g2, "flush"
    wait

[ShowData]
    #h.g, "cls ; down ; fill darkgray ; color green ; line 700 198  0 198"
    #h.t5, "t2 ="; t2
    #h.g2, "down ; color white"
    #h.g2, "line "; t1/Le*700; " 100 "; t1/Le*700; " 0"
    #h.g2, "line "; t2/Le*700; " 100 "; t2/Le*700; " 0"
    #h.g2, "color "; int(255*rnd(1)); " "; int(255*rnd(1)); " "; int(255*rnd(1)); " up "
    for x = t1 to t2 step int( (t2-t1)/700)
        scan
        x$ =mid$( i$, x, 1)
        v  =asc( x$) -128'   0 (-127) to 255 (+127) with 128 as zero
        #h.g, "goto "; (x-t1)/(t2-t1)*700; " "; 198 +f *v
    next x
    #h.g, "flush"
    #h.g2, "setfocus"
    gosub [fourier]
    wait

[fourier]
    '   Receives start and finish of sample section chosen
    '   Displays fourier analysis on the chosen one second section.
    '   NB at present doesn't check t1 is too close to end....
    #h.g3 "color white ; down ; fill blue ; flush ; backcolor blue"
    for frequency =0 to 1000 step 100
        #h.g3 "up ; goto "; frequency /1000 *700 -10; " 20"
        #h.g3 "down"
        #h.g3 "\"; frequency
    next frequency

    for frequency =10 to 1000 step 2
        ampSin =0
        ampCos =0
        for sample =46 to 46 +11025 /10
            scan
            x$ =mid$( i$, sample, 1)
            v  =asc( x$) -128   '   Signed 8-bit, so 0 (-127) to 255 (+127) with 128 as zero
            ampSin =ampSin +sin( ( sample -46) *frequency *2 *3.14159265 /11025) *v
            ampCos =ampCos +cos( ( sample -46) *frequency *2 *3.14159265 /11025) *v
        next sample
        amp( frequency) =(ampSin^2 +ampCos^2)^0.5 /500
        '   magnitude =sqrt( sinpart^2 +cospart^2)
        #h.g3 "up ;   goto "; frequency /1000 *700; " "; 88 -amp( frequency)
        #h.g3 "down ; goto "; frequency /1000 *700; " 89"
        print frequency, 50 +amp( frequency)
        #h.g3 "flush"
    next frequency
    return

[limit1]
    t1 =46 +int( MouseX /700 *Le)
    t2 =int( t1 +11025 /10)
    #h.t4, "t1 ="; t1
    #h.t5, "t2 ="; t2
    #h.b3 "!enable"
    wait

[scaleup]
    f =f*2^0.5
    #h.t1, f
    wait

[scaledown]
    f =f/2^0.5
    #h.t1, f
    wait

[quit]
    close #f
    close #h
    end


