
    '/////////////////////////////////////////////\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\

    '   RndErrorsE.bas

    '   Testing internal, modcongruent, switchtail  and other pseudo-random number generators.
    '   Also hardware-generated pre-recorded sequence from RAND corporation. (120000 values)

    '   Looks for consecutive-number association and distribution in bins of chosen size
    '       eg two bins for above/below 0.5, or decade bins.

    '   http://en.wikipedia.org/wiki/Linear_congruential_generator

    '\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\///////////////////////////////////////////////

    '   To-dos:-    add a 'square and extract middle digits' generator
    '               add a file of 'genuinely random' numbers off the net. ('RAND' Corp'n )
    '               experiment with an audio or wifi 'noise' random generator.
    '               tidy up logic so you can change type mid stream
    '               bmpsave/cls/loadbmp the g1 window regularly.
    '               move most text to a menu item; results to textboxes.
    '                   or a modal splash window at start...
    '               Add timer to trigger printouts and add time$  to printout.

    nn    =   10000000

    global ra, c, m, k,       r1, seed, pi,      le, o$,      RAND$, pp

    pi    =          3.14159265

    seed  =          0.5924

    ra    =       1234  'any seed between 0 and n- it becomes a succession of new
                'random values all in range 0 to n
    k     =    1664525              '106
                'these three numbers are carefully chosen
                'chain code gives n numbers at random before repeating
                'r is replaced by (r * k +c) mod m
    c     = 1013904223              '1283
    m     =          2^32           '6075
                'Change these numbers at your peril! Look up in a good comp. math ref'ce!

    tPass =      0

    rx    =seed

    pp    =6 * int( 19999 *rnd( 1)) '   Selects random position in RAND Corporation's random-number table.

    le    =     31
    o$    =""
    for i =1 to le
        o$ =o$ +chr$( 48 +2 *rnd( 1))
    next i

    open "digits4n.txt" for input as #R
        RAND$ = input$( #R, lof( #R))
        'print RAND$
    close #R

    bins  =256
    dim bin( bins)
    scale =  1/4

    method =     1  '   For selecting RNG to use- will become a selector or radiobuttons..

    nomainwin

    WindowWidth  =900
    WindowHeight =650
    UpperLeftX  =  10
    UpperLeftY  =  10

    graphicbox  #w.gb1,  10,  10, 512, 512

    graphicbox  #w.gb2, 580,  10, 270, 310

    texteditor  #w.te1, 530, 424, 360, 110

    groupbox #w, "Choose random generator", 540, 330, 290, 85

    radiobutton #w.rb1,  "rnd()",      [b1Clicked], [nil], 550, 350, 65, 25
    radiobutton #w.rb2,  "modcon",     [b2Clicked], [nil], 620, 350, 65, 25
    radiobutton #w.rb3,  "randpi",     [b3Clicked], [nil], 690, 350, 65, 25
    radiobutton #w.rb4,  "switchtail", [b4Clicked], [nil], 760, 350, 65, 25
    radiobutton #w.rb5,  "RAND",       [b5Clicked], [nil], 550, 390, 65, 25

    button #w.b1, "Run", [run], LR, 20, 220


    open "Random generator tests" for window as #w
   '   ______________________________________________________

    WindowWidth  =900
    WindowHeight =640

    texteditor #m.te,  30,  10, 800, 570

    open "Introduction to RandCompare" for dialog_modal as #m
        #m.te "!font arial 28 bold"
        #m.te " Choose a type, then click 'Run'. Then wait for 10 000 000 throws."
        #m.te ""
        #m.te "!font arial 18"
        open "help.txt" for input as #hh
            hh$ = input$( #hh, lof( #hh))
            #m.te hh$
        close #hh
        #m.te "!origin 1 1"

    '   _____________________________________________________


    #w "trapclose [quit]"

    h =hwnd( #w.gb1)
    calldll #user32, "GetDC", h as ulong, hDC as ulong

    #w.gb1 "down ; fill black ; flush"
    #w.gb2 "down ; fill black ; color darkblue ; flush"

    #w.rb1 "set"

    nPass = 0

    #w.te1 ""
    #w.te1 " Scale = "; scale
    wait

[run] for i = 1 to nn
            scan

            select case method  '   The argument is only an unused dummy...
            case 1
                ry =rnd( 1)                                 '   Use LB rnd generator
            case 2
                ry =randmodcon( 1)                          '   mod-congruent generator
            case 3
                ry =randpi( 1)                              '   number manipulation
            case 4
                ry =switchback( 1)                          '   Max-length switch tail ring counter
            case 5
                ry =RAND( 1)                                '   Use RAND Corp'n table.
            end select

            '    #w.te1 using( "#.##########", ry)

            if rx <0.5 then nPass =nPass +1

            xp =int( 512 *rx)                               '   Screen coordinates
            yp =int( 512 *ry)

            p  =pixelLong( hDC, xp, yp)                     '   Find present colour of target area.

            b = 0           'int(  p / 256 /256)
            g = 0           'int( (p -b *256 *256) / 256)

            r = p +64       'int(  p -b *256 *256 - g *256) +an increment each time it's 'hit'.
            if r >255 then r =255                           '   Fade up red as 'strikes' on this pair increase. Cap at 255.

            pix$ =str$( r)+ " "+ str$( g)+ " "+ str$( b)    '   Place the values in a string
            #w.gb1 "color "; pix$
            #w.gb1 "set "; int( 512 *rx); " "; int( 512 *ry)

            b =int( 256 *rx)
            bin( b) =bin( b) +1
            if ( bin( b) mod ( 300 *scale)) =0 then              '   We are hitting histogram limit 300- scale to half present size.
                scale =scale *2
                #w.gb2 "cls ; fill darkblue ; color black ; up"
                for h =0 to bins -1
                    #w.gb2 "color "; h; " "; 255 -h; " 0"
                    #w.gb2 "goto "; h +6; " "; 302 -bin( h) /scale
                    #w.gb2 "down"
                    #w.gb2 "goto "; h +6; " 300"
                    #w.gb2 "up"
                next h
                #w.gb2 "down"
                #w.te1 " Scale = "; right$( "     " +str$( scale), 5);
                #w.te1 " Throws = "; i; "   median = "; using( "#.######", nPass /i)
            end if

            #w.gb2 "color "; b; " "; 255 -b; " "; int( bin( b) /scale)
            #w.gb2 "set "; b +6; " "; 300 -bin( b) /scale

            rx =ry
        next i

        #w.te1 " Throws = "; i; "   median = "; using( "#.########", nPass /i)

    wait

        '#w.gb1 "getbmp screen 0 0 511 511"
        '   could add a screen save here...
        '#w.gb1 "cls"
        '#w.gb1 "drawbmp screen 0 0"
        'unloadbmp "screen"

function randmodcon( dummy)
    ra =( ra *k +c) mod m
    randmodcon =ra /m
end function

function randpi( dummy)
    r1     =( seed +pi)^5.04
    randpi =r1 -int( r1)
    seed   =randpi
end function

function switchback( dummy)
    f1 =val( mid$( o$,  2, 1))
    f2 =val( mid$( o$, 30,   1))
    fb =f1 xor f2                   ' shift right, losiing r.h. bit and adding xor'd fb bit at left
    o$ =chr$( 48 +fb) +left$( o$, le-1)
    ra =0
    for j =1 to le
        ra =ra +val( mid$( o$, j, 1)) *2^( j-1)
    next j
    switchback =ra /2^le
end function

function RAND( dummy)
     p$ =mid$( RAND$, pp +2, 5)
     v =val( p$) /99999
    pp =( pp +6) mod 120000
    print "Ptr "; pp; "    Substring "; p$; "    RAND = "; v
    RAND =v
end function

function pixelLong( fhDC, fxVar, fyVar)
    CallDLL #gdi32, "GetPixel",_
        fhDC    as Ulong,_
        fxVar   as Long,_
        fyVar   as Long,_
        fp      as Long
        pixelLong =fp
end Function

[b1Clicked]
    method =1
    wait
[b2Clicked]
    method =2
    wait
[b3Clicked]
    method =3
    wait

[b4Clicked]
    method =4
    wait
[b5Clicked]
    method =5
    wait

[quit]
    calldll #user32, "ReleaseDC",_
    h      as ulong,_
    hDC    as ulong,_
    re     as long

 close #m
 close #w
 end


