    ' http://soft.tahionic.com/download-hdd_id/documentation/exported%20functions%20for%20non-Delphi.html
    ' http://soft.tahionic.com/download-hdd_id/documentation/Delphi%20to%20C%20type%20conversion.html
    ' http://soft.tahionic.com/download-hdd_id/documentation/how%20to%20call%20it.html
    ' http://soft.tahionic.com/download-hdd_id/hardware%20ID%20programmer%27s%20DLL.html
    ' http://soft.tahionic.com/download-hdd_id/documentation/Windows%20Vista%20UAC.html

    ' CONSTANTS
    Dots$ = "............................................"

    ' OSMemType
    OSMemType$(1) = "Memory Load (%)"
    OSMemType$(2) = "Total Physical"
    OSMemType$(3) = "Avail Physical"
    OSMemType$(4) = "Total Page File"
    OSMemType$(5) = "Available Page File"
    OSMemType$(6) = "Total Virtual"
    OSMemType$(7) = "Available Virtual"

    ' ProcMemType
    ProcMemType$(1) = "Working Set Size"
    ProcMemType$(2) = "Page Fault Count"
    ProcMemType$(3) = "Peak Working Set Size"
    ProcMemType$(4) = "Quota Peak Paged Pool Usage"
    ProcMemType$(5) = "Quota Paged Pool Usage"
    ProcMemType$(6) = "Quota Peak Non Paged Pool Usage"
    ProcMemType$(7) = "Quota Non Paged Pool Usage"
    ProcMemType$(8) = "Pagefile Usage"
    ProcMemType$(9) = "Peak Pagefile Usage"

    ' main routines testing
    call OpenHwIDexDLL

    print
    print "CPU Information"
    print "==============="
    print
    print "CPU Speed .......................... "; GetCPUSpeed(); " MHz"
    print "CPU Family ......................... "; CPUFamily$()
    print "CPU Theoretic Speed ................ "; GetCpuTheoreticSpeed(); " MHz"
    print "Is CPU ID available ................ "; IsCPUIDAvailable()
    for Core = 1 to GetCPUCount()
        print "CPU ID Core "; Core; " ...................... "; GetCPUID$(Core)
    next
    print "CPU ID now ......................... "; GetCpuIdNow$()
    print "Is Intel(R) 64-Bit CPU ............. "; IsIntel64BitCPU()
    print "CPU Vendor ......................... "; GetCPUVendor$()
    print
    print "RAM Information"
    print "==============="
    print
    print OSMemType$(1); " "; left$(Dots$, 35 - len(OSMemType$(1))); " "; _
        MemStatWindows(1); " %"
    for OSMemType = 2 to 7
        print OSMemType$(OSMemType); " "; left$(Dots$, 35 - len(OSMemType$(OSMemType))); " "; _
            using("#############", MemStatWindows(OSMemType)); " Byte ... "; _
            using("##########", val(MemStatWindowsKB$(OSMemType))); " kiloByte ... "; _
            using("#######", val(MemStatWindowsMB$(OSMemType))); " MegaByte"
    next
    for ProcMemType = 1 to 9
        print ProcMemType$(ProcMemType); " "; left$(Dots$, 35 - len(ProcMemType$(ProcMemType))); " "; _
            using("#############", MemStatCurrProc(ProcMemType));
        if ProcMemType = 2 then
            print
        else
            print " Byte"
        end if
    next
    print "Peak Memory Used ................... "; using("#############", MemStatPeak()); " Byte"
    print
    print "RAM Advanced"
    print "============"
    print
    print "Page Size .......................... "; GetPageSize()
    print "Memory Granularity ................. "; GetMemGranularity(); " kiloByte"
    print "Lowest Address ..................... "; GetLowAddr()
    print "Highest Address .................... "; GetHiAddr()
    print
    print "HDD Information"
    print "==============="
    print
    count = 1
    do
        Drive$ = upper$(word$(Drives$, count))
        if Drive$ <> "" then
            print "Partition ID "; Drive$; " .................... "; GetPartitionID$(Drive$)
        end if
        count = count + 1
    loop until Drive$ = ""
    for DriveID = 0 to 7
        print "IDE Serial Number Drive "; DriveID; " .......... "; trim$(GetIDESerialNumber$(DriveID))
    next
    print
    print "BIOS Information"
    print "================"
    print
    print "BIOS Date .......................... "; BiosDate$()
    print "BIOS Version ....................... "; BiosVersion$()
    print "BIOS Product ID .................... "; BiosProductID$()
    print "BIOS Video ......................... "; BiosVideo$()
    print
    print "Utilities"
    print "========="
    print
    print "HardwareIDExtractorC.dll Version ... "; GetDllVersion()
    print "Bin to Integer (10011001) .......... "; BinToInt("10011001")

    call CloseHwIDexDLL
    end

sub OpenHwIDexDLL
    ' open DLL
    Open "HardwareIDExtractorC.dll" for DLL as #HwIDex
end sub

sub CloseHwIDexDLL
    ' close DLL
    close #HwIDex
end sub

sub ReleaseMemory pointer
    ' release memory used by returned String
    calldll #HwIDex, "ReleaseMemory", pointer as ulong, result as void
end sub

' CPU
function GetCPUSpeed()
    calldll #HwIDex, "GetCPUSpeed", GetCPUSpeed as double
end function

function CPUFamily$()
    calldll #HwIDex, "CPUFamily", pointer as ulong
    CPUFamily$ = winstring(pointer)
    call ReleaseMemory pointer
end function

function GetCpuTheoreticSpeed()
    calldll #HwIDex, "GetCpuTheoreticSpeed", GetCpuTheoreticSpeed as long
end function

function IsCPUIDAvailable()
    calldll #HwIDex, "IsCPUIDAvailable", result as ulong
    IsCPUIDAvailable = (result > 0)
end function

function GetCPUID$(CoreNo)
    calldll #HwIDex, "CoreNumber2CoreMask", CoreNo as long, CoreMask as long
    calldll #HwIDex, "GetCPUID", CoreMask as word, pointer as ulong
    GetCPUID$ = winstring(pointer)
    call ReleaseMemory pointer
end function

function GetCpuIdNow$()
    calldll #HwIDex, "GetCpuIdNow", pointer as ulong
    GetCpuIdNow$ = winstring(pointer)
    call ReleaseMemory pointer
end function

function GetCPUCount()
    calldll #HwIDex, "GetCPUCount", GetCPUCount as long
end function

function IsIntel64BitCPU()
    calldll #HwIDex, "IsIntel64BitCPU", result as ulong
    IsIntel64BitCPU = (result > 0)
end function

function GetCPUVendor$()
    calldll #HwIDex, "GetCPUVendor", pointer as ulong
    GetCPUVendor$ = winstring(pointer)
    call ReleaseMemory pointer
end function

' RAM
function MemStatWindows(OSMemType)
    calldll #HwIDex, "MemStatWindows", OSMemType as ushort, MemStatWindows as ulong
end function

function MemStatWindowsKB$(OSMemType)
    calldll #HwIDex, "MemStatWindows_KB", OSMemType as ushort, pointer as ulong
    MemStatWindowsKB$ = winstring(pointer)
    call ReleaseMemory pointer
end function

function MemStatWindowsMB$(OSMemType)
    calldll #HwIDex, "MemStatWindows_MB", OSMemType as ushort, pointer as ulong
    MemStatWindowsMB$ = winstring(pointer)
    call ReleaseMemory pointer
end function

function MemStatCurrProc(ProcMemType)
    calldll #HwIDex, "MemStatCurrProc", ProcMemType as ushort, MemStatCurrProc as ulong
end function

function MemStatPeak()
    calldll #HwIDex, "MemStatPeak", MemStatPeak as ulong
end function

' RAM - Advanced stuff
function GetPageSize()
    calldll #HwIDex, "GetPageSize", GetPageSize as ulong
end function

function GetMemGranularity()
    calldll #HwIDex, "GetMemGranularity", GetMemGranularity as long
end function

function GetLowAddr()
    calldll #HwIDex, "GetLowAddr", GetLowAddr as ulong
end function

function GetHiAddr()
    calldll #HwIDex, "GetHiAddr", GetHiAddr as ulong
end function

' HDD
function GetPartitionID$(Partition$)
    calldll #HwIDex, "GetPartitionID", Partition$ as ptr, pointer as ulong
    GetPartitionID$ = winstring(pointer)
    call ReleaseMemory pointer
end function

function GetIDESerialNumber$(DriveNumber)
    calldll #HwIDex, "GetIDESerialNumber", DriveNumber as ushort, pointer as ulong
    GetIDESerialNumber$ = winstring(pointer)
    call ReleaseMemory pointer
end function

' BIOS (NEW!)
function BiosDate$()
    calldll #HwIDex, "BiosDate", pointer as ulong
    BiosDate$ = winstring(pointer)
    call ReleaseMemory pointer
end function

function BiosVersion$()
    calldll #HwIDex, "BiosVersion", pointer as ulong
    BiosVersion$ = winstring(pointer)
    call ReleaseMemory pointer
end function

function BiosProductID$()
    calldll #HwIDex, "BiosProductID", pointer as ulong
    BiosProductID$ = winstring(pointer)
    call ReleaseMemory pointer
end function

function BiosVideo$()
    calldll #HwIDex, "BiosVideo", pointer as ulong
    BiosVideo$ = winstring(pointer)
    call ReleaseMemory pointer
end function

' Utils
function BinToInt(Value$)
    calldll #HwIDex, "BinToInt", Value$ as ptr, BinToInt as long
end function

function GetDllVersion()
    calldll #HwIDex, "GetDllVersion", GetDllVersion as double
end function
 
